/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.sink.internal.committables;

import io.delta.flink.sink.internal.committables.DeltaCommittable;
import java.io.IOException;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.functions.sink.filesystem.DeltaPendingFile;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.util.Preconditions;

public class DeltaCommittableSerializer
implements SimpleVersionedSerializer<DeltaCommittable> {
    private static final int MAGIC_NUMBER = 511073408;
    private final SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> pendingFileSerializer;

    public DeltaCommittableSerializer(SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> simpleVersionedSerializer) {
        this.pendingFileSerializer = (SimpleVersionedSerializer)Preconditions.checkNotNull(simpleVersionedSerializer);
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(DeltaCommittable deltaCommittable) throws IOException {
        DataOutputSerializer dataOutputSerializer = new DataOutputSerializer(256);
        dataOutputSerializer.writeInt(511073408);
        this.serializeV1(deltaCommittable, (DataOutputView)dataOutputSerializer);
        return dataOutputSerializer.getCopyOfBuffer();
    }

    public DeltaCommittable deserialize(int n, byte[] byArray) throws IOException {
        DataInputDeserializer dataInputDeserializer = new DataInputDeserializer(byArray);
        if (n == 1) {
            DeltaCommittableSerializer.validateMagicNumber((DataInputView)dataInputDeserializer);
            return this.deserializeV1((DataInputView)dataInputDeserializer);
        }
        throw new IOException("Unrecognized version or corrupt state: " + n);
    }

    void serializeV1(DeltaCommittable deltaCommittable, DataOutputView dataOutputView) throws IOException {
        dataOutputView.writeUTF(deltaCommittable.getAppId());
        dataOutputView.writeLong(deltaCommittable.getCheckpointId());
        DeltaPendingFile.serialize(deltaCommittable.getDeltaPendingFile(), dataOutputView, this.pendingFileSerializer);
    }

    DeltaCommittable deserializeV1(DataInputView dataInputView) throws IOException {
        String string = dataInputView.readUTF();
        long l = dataInputView.readLong();
        DeltaPendingFile deltaPendingFile = DeltaPendingFile.deserialize(dataInputView, this.pendingFileSerializer);
        return new DeltaCommittable(deltaPendingFile, string, l);
    }

    private static void validateMagicNumber(DataInputView dataInputView) throws IOException {
        int n = dataInputView.readInt();
        if (n != 511073408) {
            throw new IOException(String.format("Corrupt data: Unexpected magic number %08X", n));
        }
    }
}

