/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.sink.internal.writer;

import io.delta.flink.sink.internal.writer.DeltaWriterBucketState;
import java.io.IOException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaWriterBucketStateSerializer
implements SimpleVersionedSerializer<DeltaWriterBucketState> {
    private static final Logger LOG = LoggerFactory.getLogger(DeltaWriterBucketStateSerializer.class);
    private static final int MAGIC_NUMBER = 511069049;

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(DeltaWriterBucketState deltaWriterBucketState) throws IOException {
        DataOutputSerializer dataOutputSerializer = new DataOutputSerializer(256);
        dataOutputSerializer.writeInt(511069049);
        this.serializeV2(deltaWriterBucketState, (DataOutputView)dataOutputSerializer);
        return dataOutputSerializer.getCopyOfBuffer();
    }

    public DeltaWriterBucketState deserialize(int n, byte[] byArray) throws IOException {
        DataInputDeserializer dataInputDeserializer = new DataInputDeserializer(byArray);
        if (n == 1) {
            this.validateMagicNumber((DataInputView)dataInputDeserializer);
            return this.deserializeV1((DataInputView)dataInputDeserializer);
        }
        if (n == 2) {
            this.validateMagicNumber((DataInputView)dataInputDeserializer);
            return this.deserializeV2((DataInputView)dataInputDeserializer);
        }
        throw new IOException("Unrecognized version or corrupt state: " + n);
    }

    private void serializeV2(DeltaWriterBucketState deltaWriterBucketState, DataOutputView dataOutputView) throws IOException {
        SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)SimpleVersionedStringSerializer.INSTANCE, (Object)deltaWriterBucketState.getBucketId(), (DataOutputView)dataOutputView);
        dataOutputView.writeUTF(deltaWriterBucketState.getBucketPath().toString());
        dataOutputView.writeUTF(deltaWriterBucketState.getAppId());
    }

    private DeltaWriterBucketState deserializeV1(DataInputView dataInputView) throws IOException {
        LOG.info("Deserializing obsolete V1 Bucket State. CheckpointId stored in state will be ignored.");
        return this.internalDeserialize(dataInputView);
    }

    private DeltaWriterBucketState deserializeV2(DataInputView dataInputView) throws IOException {
        return this.internalDeserialize(dataInputView);
    }

    private DeltaWriterBucketState internalDeserialize(DataInputView dataInputView) throws IOException {
        String string = (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)SimpleVersionedStringSerializer.INSTANCE, (DataInputView)dataInputView);
        String string2 = dataInputView.readUTF();
        String string3 = dataInputView.readUTF();
        return new DeltaWriterBucketState(string, new Path(string2), string3);
    }

    private void validateMagicNumber(DataInputView dataInputView) throws IOException {
        int n = dataInputView.readInt();
        if (n != 511069049) {
            throw new IOException(String.format("Corrupt data: Unexpected magic number %08X", n));
        }
    }
}

