/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal;

import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.BinaryType;
import io.delta.standalone.types.BooleanType;
import io.delta.standalone.types.ByteType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.DateType;
import io.delta.standalone.types.DecimalType;
import io.delta.standalone.types.DoubleType;
import io.delta.standalone.types.FloatType;
import io.delta.standalone.types.IntegerType;
import io.delta.standalone.types.LongType;
import io.delta.standalone.types.MapType;
import io.delta.standalone.types.NullType;
import io.delta.standalone.types.ShortType;
import io.delta.standalone.types.StringType;
import io.delta.standalone.types.StructType;
import io.delta.standalone.types.TimestampType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum DeltaDataType {
    ARRAY(ArrayType.class),
    BINARY(BinaryType.class),
    BYTE(ByteType.class),
    BOOLEAN(BooleanType.class),
    DATE(DateType.class),
    DECIMAL(DecimalType.class),
    DOUBLE(DoubleType.class),
    FLOAT(FloatType.class),
    INTEGER(IntegerType.class),
    LONG(LongType.class),
    MAP(MapType.class),
    NULL(NullType.class),
    SMALLINT(ShortType.class),
    TIMESTAMP(TimestampType.class),
    TINYINT(ByteType.class),
    STRING(StringType.class),
    STRUCT(StructType.class),
    OTHER(null);

    private static final Map<Class<?>, DeltaDataType> LOOKUP_MAP;
    private final Class<? extends DataType> deltaDataTypeClass;

    private DeltaDataType(Class<? extends DataType> clazz) {
        this.deltaDataTypeClass = clazz;
    }

    public static DeltaDataType instanceFrom(Class<? extends DataType> clazz) {
        return LOOKUP_MAP.getOrDefault(clazz, OTHER);
    }

    static {
        HashMap<Class<? extends DataType>, DeltaDataType> hashMap = new HashMap<Class<? extends DataType>, DeltaDataType>();
        for (DeltaDataType deltaDataType : DeltaDataType.values()) {
            hashMap.put(deltaDataType.deltaDataTypeClass, deltaDataType);
        }
        LOOKUP_MAP = Collections.unmodifiableMap(hashMap);
    }
}

