/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.builder;

import io.delta.flink.internal.options.DeltaConnectorConfiguration;
import io.delta.flink.internal.options.DeltaOptionValidationException;
import io.delta.flink.internal.options.OptionValidator;
import io.delta.flink.source.DeltaSource;
import io.delta.flink.source.internal.DeltaSourceOptions;
import io.delta.flink.source.internal.builder.Validator;
import io.delta.flink.source.internal.enumerator.supplier.SnapshotSupplier;
import io.delta.flink.source.internal.enumerator.supplier.SnapshotSupplierFactory;
import io.delta.flink.source.internal.exceptions.DeltaSourceExceptions;
import io.delta.flink.source.internal.file.AddFileEnumerator;
import io.delta.flink.source.internal.file.DeltaFileEnumerator;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import io.delta.flink.source.internal.utils.SourceSchema;
import io.delta.flink.source.internal.utils.SourceUtils;
import io.delta.standalone.DeltaLog;
import io.delta.standalone.Snapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.connector.file.src.assigners.LocalityAwareSplitAssigner;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.conf.Configuration;

public abstract class DeltaSourceBuilderBase<T, SELF> {
    protected static final FileSplitAssigner.Provider DEFAULT_SPLIT_ASSIGNER = LocalityAwareSplitAssigner::new;
    protected static final AddFileEnumerator.Provider<DeltaSourceSplit> DEFAULT_SPLITTABLE_FILE_ENUMERATOR = DeltaFileEnumerator::new;
    protected static final List<String> DEFAULT_COLUMNS = new ArrayList<String>(0);
    protected static final String EXCEPTION_PREFIX = "DeltaSourceBuilder - ";
    protected final DeltaConnectorConfiguration sourceConfiguration = new DeltaConnectorConfiguration();
    private final OptionValidator optionValidator;
    protected final Path tablePath;
    protected final Configuration hadoopConfiguration;
    protected final SnapshotSupplierFactory snapshotSupplierFactory;
    protected List<String> userColumnNames;

    protected DeltaSourceBuilderBase(Path path, Configuration configuration, SnapshotSupplierFactory snapshotSupplierFactory) {
        this.tablePath = path;
        this.hadoopConfiguration = configuration;
        this.snapshotSupplierFactory = snapshotSupplierFactory;
        this.userColumnNames = DEFAULT_COLUMNS;
        this.optionValidator = new OptionValidator(path, this.sourceConfiguration, DeltaSourceOptions.USER_FACING_SOURCE_OPTIONS);
    }

    public SELF columnNames(List<String> list) {
        this.userColumnNames = list;
        return this.self();
    }

    public SELF option(String string, String string2) {
        this.optionValidator.option(string, string2);
        return this.self();
    }

    public SELF option(String string, boolean bl) {
        this.optionValidator.option(string, bl);
        return this.self();
    }

    public SELF option(String string, int n) {
        this.optionValidator.option(string, n);
        return this.self();
    }

    public SELF option(String string, long l) {
        this.optionValidator.option(string, l);
        return this.self();
    }

    public DeltaConnectorConfiguration getSourceConfiguration() {
        return this.sourceConfiguration.copy();
    }

    public abstract <V extends DeltaSource<T>> V build();

    protected abstract Validator validateOptionExclusions();

    protected abstract Collection<String> getApplicableOptions();

    protected void validate() {
        Validator validator = this.validateMandatoryOptions();
        Validator validator2 = this.validateOptionExclusions();
        Validator validator3 = this.validateInapplicableOptions();
        Validator validator4 = this.validateOptionalParameters();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(validator.getValidationMessages());
        linkedList.addAll(validator2.getValidationMessages());
        linkedList.addAll(validator4.getValidationMessages());
        linkedList.addAll(validator3.getValidationMessages());
        if (!linkedList.isEmpty()) {
            String string = this.tablePath != null ? SourceUtils.pathToString(this.tablePath) : "null";
            throw new DeltaOptionValidationException(string, linkedList);
        }
    }

    protected Validator validateMandatoryOptions() {
        return new Validator().checkNotNull(this.tablePath, "DeltaSourceBuilder - missing path to Delta table.").checkNotNull(this.hadoopConfiguration, "DeltaSourceBuilder - missing Hadoop configuration.");
    }

    protected Validator validateOptionalParameters() {
        Validator validator = new Validator();
        if (this.userColumnNames != DEFAULT_COLUMNS) {
            validator.checkNotNull(this.userColumnNames, "DeltaSourceBuilder - used a null reference for user columns.");
            if (this.userColumnNames != null) {
                validator.checkArgument(!this.userColumnNames.isEmpty(), "DeltaSourceBuilder - user column names list is empty.");
                if (!this.userColumnNames.isEmpty()) {
                    validator.checkArgument(this.userColumnNames.stream().noneMatch(StringUtils::isNullOrWhitespaceOnly), "DeltaSourceBuilder - user column names list contains at least one element that is null, empty, or has only whitespace characters.");
                }
            }
        }
        return validator;
    }

    protected Validator validateInapplicableOptions() {
        Validator validator = new Validator();
        this.sourceConfiguration.getUsedOptions().stream().filter(DeltaSourceOptions::isUserFacingOption).forEach(string -> validator.checkArgument(this.getApplicableOptions().contains(string), this.prepareInapplicableOptionMessage(this.sourceConfiguration.getUsedOptions(), this.getApplicableOptions())));
        return validator;
    }

    protected String prepareOptionExclusionMessage(String ... stringArray) {
        return String.format("Used mutually exclusive options for Source definition. Invalid options [%s]", String.join((CharSequence)",", stringArray));
    }

    protected String prepareInapplicableOptionMessage(Collection<String> collection, Collection<String> collection2) {
        return String.format("Used inapplicable option for source configuration. Used options [%s], applicable options [%s]", collection, collection2);
    }

    protected SourceSchema getSourceSchema() {
        DeltaLog deltaLog = DeltaLog.forTable((Configuration)this.hadoopConfiguration, (String)SourceUtils.pathToString(this.tablePath));
        SnapshotSupplier snapshotSupplier = this.snapshotSupplierFactory.create(deltaLog);
        Snapshot snapshot = snapshotSupplier.getSnapshot(this.sourceConfiguration);
        try {
            return SourceSchema.fromSnapshot(this.userColumnNames, snapshot);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DeltaSourceExceptions.generalSourceException(SourceUtils.pathToString(this.tablePath), snapshot.getVersion(), illegalArgumentException);
        }
    }

    protected SELF self() {
        return (SELF)this;
    }
}

