/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.state;

import io.delta.flink.source.internal.state.DeltaSourceSplit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.FileSourceSplitSerializer;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.Preconditions;

public final class DeltaSourceSplitSerializer
implements SimpleVersionedSerializer<DeltaSourceSplit> {
    public static final DeltaSourceSplitSerializer INSTANCE = new DeltaSourceSplitSerializer();
    private static final MapSerializer<String, String> partitionSerDe = new MapSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
    private static final int VERSION = 1;

    private DeltaSourceSplitSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(DeltaSourceSplit deltaSourceSplit) throws IOException {
        Preconditions.checkArgument((((Object)((Object)deltaSourceSplit)).getClass() == DeltaSourceSplit.class ? 1 : 0) != 0, (String)"Only supports %s", (Object[])new Object[]{DeltaSourceSplit.class.getName()});
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputViewStreamWrapper dataOutputViewStreamWrapper = new DataOutputViewStreamWrapper((OutputStream)byteArrayOutputStream);){
            this.serialize(dataOutputViewStreamWrapper, deltaSourceSplit);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public DeltaSourceSplit deserialize(int n, byte[] byArray) throws IOException {
        if (n == 1) {
            return this.tryDeserializeV1(byArray);
        }
        throw new IOException("Unknown version: " + n);
    }

    private DeltaSourceSplit tryDeserializeV1(byte[] byArray) throws IOException {
        try (DataInputViewStreamWrapper dataInputViewStreamWrapper = new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(byArray));){
            DeltaSourceSplit deltaSourceSplit = this.deserializeV1(dataInputViewStreamWrapper);
            return deltaSourceSplit;
        }
    }

    private DeltaSourceSplit deserializeV1(DataInputViewStreamWrapper dataInputViewStreamWrapper) throws IOException {
        int n = dataInputViewStreamWrapper.readInt();
        byte[] byArray = new byte[n];
        dataInputViewStreamWrapper.readFully(byArray);
        FileSourceSplit fileSourceSplit = FileSourceSplitSerializer.INSTANCE.deserialize(FileSourceSplitSerializer.INSTANCE.getVersion(), byArray);
        Map map = partitionSerDe.deserialize((DataInputView)dataInputViewStreamWrapper);
        return new DeltaSourceSplit((Map<String, String>)map, fileSourceSplit.splitId(), fileSourceSplit.path(), fileSourceSplit.offset(), fileSourceSplit.length(), fileSourceSplit.hostnames(), fileSourceSplit.getReaderPosition().orElse(null));
    }

    private void serialize(DataOutputViewStreamWrapper dataOutputViewStreamWrapper, DeltaSourceSplit deltaSourceSplit) throws IOException {
        byte[] byArray = FileSourceSplitSerializer.INSTANCE.serialize(new FileSourceSplit(deltaSourceSplit.splitId(), deltaSourceSplit.path(), deltaSourceSplit.offset(), deltaSourceSplit.length(), deltaSourceSplit.hostnames(), (CheckpointedPosition)deltaSourceSplit.getReaderPosition().orElse(null)));
        dataOutputViewStreamWrapper.writeInt(byArray.length);
        dataOutputViewStreamWrapper.write(byArray);
        partitionSerDe.serialize(deltaSourceSplit.getPartitionValues(), (DataOutputView)dataOutputViewStreamWrapper);
    }
}

