/*
 * Decompiled with CFR 0.152.
 */
package io.delta.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexPredicateAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(IndexPredicateAnalyzer.class);
    private final Set<String> udfNames = new HashSet<String>();
    private final Map<String, Set<String>> columnToUDFs = new HashMap<String, Set<String>>();

    public void addComparisonOp(String string) {
        this.udfNames.add(string);
    }

    public void clearAllowedColumnNames() {
        this.columnToUDFs.clear();
    }

    public void allowColumnName(String string) {
        this.columnToUDFs.put(string, this.udfNames);
    }

    public void addComparisonOp(String string, String ... stringArray) {
        Set<String> set = this.columnToUDFs.get(string);
        if (set == null || set == this.udfNames) {
            this.columnToUDFs.put(string, new HashSet<String>(Arrays.asList(stringArray)));
        } else {
            set.addAll(Arrays.asList(stringArray));
        }
    }

    public ExprNodeDesc analyzePredicate(ExprNodeDesc exprNodeDesc, final List<IndexSearchCondition> list) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        NodeProcessor nodeProcessor = new NodeProcessor(){

            public Object process(Node node, Stack<Node> stack, NodeProcessorCtx nodeProcessorCtx, Object ... objectArray) throws SemanticException {
                Node node2;
                Iterator iterator = stack.iterator();
                while (iterator.hasNext() && node != (node2 = (Node)iterator.next())) {
                    if (FunctionRegistry.isOpAnd((ExprNodeDesc)((ExprNodeDesc)node2))) continue;
                    return node;
                }
                return IndexPredicateAnalyzer.this.analyzeExpr((ExprNodeGenericFuncDesc)node, list, objectArray);
            }
        };
        DefaultRuleDispatcher defaultRuleDispatcher = new DefaultRuleDispatcher(nodeProcessor, linkedHashMap, null);
        DefaultGraphWalker defaultGraphWalker = new DefaultGraphWalker((Dispatcher)defaultRuleDispatcher);
        ArrayList<ExprNodeDesc> arrayList = new ArrayList<ExprNodeDesc>();
        arrayList.add(exprNodeDesc);
        HashMap hashMap = new HashMap();
        try {
            defaultGraphWalker.startWalking(arrayList, hashMap);
        }
        catch (SemanticException semanticException) {
            throw new RuntimeException(semanticException);
        }
        ExprNodeDesc exprNodeDesc2 = (ExprNodeDesc)hashMap.get(exprNodeDesc);
        return exprNodeDesc2;
    }

    private ExprNodeDesc getColumnExpr(ExprNodeDesc exprNodeDesc) {
        if (exprNodeDesc instanceof ExprNodeColumnDesc) {
            return exprNodeDesc;
        }
        ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = null;
        if (exprNodeDesc instanceof ExprNodeGenericFuncDesc) {
            exprNodeGenericFuncDesc = (ExprNodeGenericFuncDesc)exprNodeDesc;
        }
        if (null == exprNodeGenericFuncDesc) {
            return exprNodeDesc;
        }
        GenericUDF genericUDF = exprNodeGenericFuncDesc.getGenericUDF();
        if ((genericUDF instanceof GenericUDFBridge || genericUDF instanceof GenericUDFToBinary || genericUDF instanceof GenericUDFToChar || genericUDF instanceof GenericUDFToVarchar || genericUDF instanceof GenericUDFToDecimal || genericUDF instanceof GenericUDFToDate || genericUDF instanceof GenericUDFToUnixTimeStamp || genericUDF instanceof GenericUDFToUtcTimestamp) && exprNodeGenericFuncDesc.getChildren().size() == 1 && exprNodeGenericFuncDesc.getChildren().get(0) instanceof ExprNodeColumnDesc) {
            return (ExprNodeDesc)exprNodeDesc.getChildren().get(0);
        }
        return exprNodeDesc;
    }

    private ExprNodeDesc analyzeExpr(ExprNodeGenericFuncDesc exprNodeGenericFuncDesc, List<IndexSearchCondition> list, Object ... objectArray) throws SemanticException {
        Object object;
        if (FunctionRegistry.isOpAnd((ExprNodeDesc)exprNodeGenericFuncDesc)) {
            assert (objectArray.length >= 2);
            ArrayList<ExprNodeDesc> arrayList = new ArrayList<ExprNodeDesc>();
            for (Object object2 : objectArray) {
                if (null == object2) continue;
                arrayList.add((ExprNodeDesc)object2);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            if (arrayList.size() == 1) {
                return (ExprNodeDesc)arrayList.get(0);
            }
            return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), arrayList);
        }
        GenericUDF genericUDF = exprNodeGenericFuncDesc.getGenericUDF();
        ExprNodeDesc[] exprNodeDescArray = new ExprNodeDesc[objectArray.length];
        ArrayList<ExprNodeColumnDesc> arrayList = new ArrayList<ExprNodeColumnDesc>();
        ArrayList<ExprNodeConstantDesc> arrayList2 = new ArrayList<ExprNodeConstantDesc>();
        for (int i = 0; i < objectArray.length; ++i) {
            object = this.getColumnExpr((ExprNodeDesc)objectArray[i]);
            if (object instanceof ExprNodeColumnDesc) {
                arrayList.add((ExprNodeColumnDesc)object);
            } else if (object instanceof ExprNodeConstantDesc) {
                arrayList2.add((ExprNodeConstantDesc)object);
            }
            exprNodeDescArray[i] = object;
        }
        if (arrayList.size() != 1) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Pushed down expr should only have one column, while it is " + StringUtils.join((Object[])arrayList.toArray()));
            }
            return exprNodeGenericFuncDesc;
        }
        ExprNodeColumnDesc exprNodeColumnDesc = (ExprNodeColumnDesc)arrayList.get(0);
        object = this.columnToUDFs.get(exprNodeColumnDesc.getColumn());
        if (object == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("This column " + exprNodeColumnDesc.getColumn() + " is not allowed to pushed down to delta...");
            }
            return exprNodeGenericFuncDesc;
        }
        String string = genericUDF.getUdfName();
        if (genericUDF instanceof GenericUDFBridge) {
            string = ((GenericUDFBridge)genericUDF).getUdfClassName();
        }
        if (!object.contains(string)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("This udf " + genericUDF.getUdfName() + " is not allowed to pushed down to delta...");
            }
            return exprNodeGenericFuncDesc;
        }
        if (!string.equals("org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn") && arrayList2.size() > 1) {
            if (LOG.isInfoEnabled()) {
                LOG.info("There should be one constant in this udf(" + string + ") except UDFIn");
            }
            return exprNodeGenericFuncDesc;
        }
        ExprNodeGenericFuncDesc exprNodeGenericFuncDesc2 = new ExprNodeGenericFuncDesc(exprNodeGenericFuncDesc.getTypeInfo(), exprNodeGenericFuncDesc.getGenericUDF(), Arrays.asList(exprNodeDescArray));
        list.add(new IndexSearchCondition(exprNodeColumnDesc, string, null, exprNodeGenericFuncDesc2, exprNodeGenericFuncDesc, null));
        return null;
    }

    public ExprNodeGenericFuncDesc translateSearchConditions(List<IndexSearchCondition> list) {
        ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = null;
        for (IndexSearchCondition indexSearchCondition : list) {
            if (exprNodeGenericFuncDesc == null) {
                exprNodeGenericFuncDesc = indexSearchCondition.getIndexExpr();
                continue;
            }
            ArrayList<ExprNodeGenericFuncDesc> arrayList = new ArrayList<ExprNodeGenericFuncDesc>();
            arrayList.add(exprNodeGenericFuncDesc);
            arrayList.add(indexSearchCondition.getIndexExpr());
            exprNodeGenericFuncDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), arrayList);
        }
        return exprNodeGenericFuncDesc;
    }

    public ExprNodeGenericFuncDesc translateOriginalConditions(List<IndexSearchCondition> list) {
        ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = null;
        for (IndexSearchCondition indexSearchCondition : list) {
            if (exprNodeGenericFuncDesc == null) {
                exprNodeGenericFuncDesc = indexSearchCondition.getOriginalExpr();
                continue;
            }
            ArrayList<ExprNodeGenericFuncDesc> arrayList = new ArrayList<ExprNodeGenericFuncDesc>();
            arrayList.add(exprNodeGenericFuncDesc);
            arrayList.add(indexSearchCondition.getOriginalExpr());
            exprNodeGenericFuncDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), arrayList);
        }
        return exprNodeGenericFuncDesc;
    }
}

