/*
 * Decompiled with CFR 0.152.
 */
package io.delta.hive;

import io.delta.hive.CaseInsensitiveMap$;
import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.MapType;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import java.io.Serializable;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;

public final class SchemaUtils$ {
    public static SchemaUtils$ MODULE$;

    static {
        new SchemaUtils$();
    }

    public Seq<String> reportDifferences(StructType existingSchema, StructType specifiedSchema) {
        return this.structDifference$1(existingSchema, specifiedSchema, "");
    }

    private Map<String, StructField> toFieldMap(Seq<StructField> fields) {
        return CaseInsensitiveMap$.MODULE$.apply(((TraversableOnce)fields.map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private static final String canOrNot$1(boolean can) {
        if (can) {
            return "can";
        }
        return "can not";
    }

    private static final String isOrNon$1(boolean b) {
        if (b) {
            return "";
        }
        return "non-";
    }

    private static final String missingFieldsMessage$1(Set fields) {
        return new StringBuilder(38).append("Specified schema is missing field(s): ").append(fields.mkString(", ")).toString();
    }

    private static final String additionalFieldsMessage$1(Set fields) {
        return new StringBuilder(42).append("Specified schema has additional field(s): ").append(fields.mkString(", ")).toString();
    }

    private static final String fieldNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(71).append("Field ").append(field).append(" is ").append(SchemaUtils$.isOrNon$1(specified)).append("nullable in specified ").append("schema but ").append(SchemaUtils$.isOrNon$1(existing)).append("nullable in existing schema.").toString();
    }

    private static final String arrayNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(70).append("Array field ").append(field).append(" ").append(SchemaUtils$.canOrNot$1(specified)).append(" contain null in specified schema ").append("but ").append(SchemaUtils$.canOrNot$1(existing)).append(" in existing schema").toString();
    }

    private static final String valueNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(75).append("Map field ").append(field).append(" ").append(SchemaUtils$.canOrNot$1(specified)).append(" contain null values in specified schema ").append("but ").append(SchemaUtils$.canOrNot$1(existing)).append(" in existing schema").toString();
    }

    private static final String typeDifferenceMessage$1(String field, DataType specified, DataType existing) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("Specified type for ").append(field).append(" is different from existing schema:\n         |Specified: ").append(specified.getTypeName()).append("\n         |Existing:  ").append(existing.getTypeName()).toString())).stripMargin();
    }

    private final Seq structDifference$1(StructType existing, StructType specified, String prefix) {
        Set specifiedFieldNames;
        Set existingFieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existing.getFieldNames())).toSet();
        Set missingFields = (Set)existingFieldNames.diff((GenSet)(specifiedFieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])specified.getFieldNames())).toSet()));
        Nil$ missingFieldsDiffs = missingFields.isEmpty() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.missingFieldsMessage$1((Set)missingFields.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(0).append(prefix).append((String)x$1).toString(), Set$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$);
        Set extraFields = (Set)specifiedFieldNames.diff((GenSet)existingFieldNames);
        Nil$ extraFieldsDiffs = extraFields.isEmpty() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.additionalFieldsMessage$1((Set)extraFields.map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(0).append(prefix).append((String)x$2).toString(), Set$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$);
        boolean columnsOutOfOrder = missingFields.isEmpty() && extraFields.isEmpty() && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existing.getFieldNames())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])specified.getFieldNames()));
        Nil$ columnsOutOfOrderMsg = columnsOutOfOrder ? (Seq)new .colon.colon((Object)"Columns out of order", (List)Nil$.MODULE$) : Nil$.MODULE$;
        Map<String, StructField> existingFields = this.toFieldMap((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])existing.getFields()));
        Map<String, StructField> specifiedFields = this.toFieldMap((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])specified.getFields()));
        Set fieldsDiffs = (Set)((TraversableLike)existingFieldNames.intersect((GenSet)specifiedFieldNames)).flatMap((Function1 & Serializable & scala.Serializable)name -> this.fieldDifference$1((StructField)existingFields.apply(name), (StructField)specifiedFields.apply(name), prefix), Set$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)((TraversableLike)missingFieldsDiffs.$plus$plus((GenTraversableOnce)extraFieldsDiffs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)fieldsDiffs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)columnsOutOfOrderMsg, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq fieldDifference$1(StructField existing, StructField specified, String prefix) {
        String name = new StringBuilder(0).append(prefix).append(existing.getName()).toString();
        Nil$ nullabilityDiffs = existing.isNullable() == specified.isNullable() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.fieldNullabilityMessage$1(String.valueOf(name), specified.isNullable(), existing.isNullable()), (List)Nil$.MODULE$);
        Seq typeDiffs = this.typeDifference$1(existing.getDataType(), specified.getDataType(), name);
        return (Seq)nullabilityDiffs.$plus$plus((GenTraversableOnce)typeDiffs, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq typeDifference$1(DataType existing, DataType specified, String field) {
        Tuple2 tuple2 = new Tuple2((Object)existing, (Object)specified);
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof StructType) {
                StructType structType = (StructType)e;
                if (s instanceof StructType) {
                    StructType structType2 = (StructType)s;
                    return this.structDifference$1(structType, structType2, new StringBuilder(1).append(field).append(".").toString());
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)e;
                if (s instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)s;
                    return this.arrayDifference$1(arrayType, arrayType2, new StringBuilder(2).append(field).append("[]").toString());
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof MapType) {
                MapType mapType = (MapType)e;
                if (s instanceof MapType) {
                    MapType mapType2 = (MapType)s;
                    return this.mapDifference$1(mapType, mapType2, String.valueOf(field));
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            DataType dataType = e;
            DataType dataType2 = s;
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                return (Seq)new .colon.colon((Object)SchemaUtils$.typeDifferenceMessage$1(field, s, e), (List)Nil$.MODULE$);
            }
        }
        return Nil$.MODULE$;
    }

    private final Seq arrayDifference$1(ArrayType existing, ArrayType specified, String field) {
        Seq elementDiffs = this.typeDifference$1(existing.getElementType(), specified.getElementType(), field);
        Nil$ nullabilityDiffs = existing.containsNull() == specified.containsNull() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.arrayNullabilityMessage$1(field, specified.containsNull(), existing.containsNull()), (List)Nil$.MODULE$);
        return (Seq)elementDiffs.$plus$plus((GenTraversableOnce)nullabilityDiffs, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq mapDifference$1(MapType existing, MapType specified, String field) {
        Seq keyDiffs = this.typeDifference$1(existing.getKeyType(), specified.getKeyType(), new StringBuilder(5).append(field).append("[key]").toString());
        Seq valueDiffs = this.typeDifference$1(existing.getValueType(), specified.getValueType(), new StringBuilder(7).append(field).append("[value]").toString());
        Nil$ nullabilityDiffs = existing.valueContainsNull() == specified.valueContainsNull() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.valueNullabilityMessage$1(field, specified.valueContainsNull(), existing.valueContainsNull()), (List)Nil$.MODULE$);
        return (Seq)((TraversableLike)keyDiffs.$plus$plus((GenTraversableOnce)valueDiffs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)nullabilityDiffs, Seq$.MODULE$.canBuildFrom());
    }

    private SchemaUtils$() {
        MODULE$ = this;
    }
}

