/*
 * Decompiled with CFR 0.152.
 */
package io.delta.hive;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.delta.hive.DeltaStorageHandler$;
import io.delta.hive.PartitionColumnInfo;
import io.delta.hive.SchemaUtils$;
import io.delta.standalone.DeltaLog;
import io.delta.standalone.Snapshot;
import io.delta.standalone.actions.AddFile;
import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.BinaryType;
import io.delta.standalone.types.BooleanType;
import io.delta.standalone.types.ByteType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.DateType;
import io.delta.standalone.types.DecimalType;
import io.delta.standalone.types.DoubleType;
import io.delta.standalone.types.FloatType;
import io.delta.standalone.types.IntegerType;
import io.delta.standalone.types.LongType;
import io.delta.standalone.types.MapType;
import io.delta.standalone.types.ShortType;
import io.delta.standalone.types.StringType;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import io.delta.standalone.types.TimestampType;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

public final class DeltaHelper$ {
    public static DeltaHelper$ MODULE$;
    private final Logger io$delta$hive$DeltaHelper$$LOG;
    private final Cache<Path, DeltaLog> deltaLogCache;

    static {
        new DeltaHelper$();
    }

    public Logger io$delta$hive$DeltaHelper$$LOG() {
        return this.io$delta$hive$DeltaHelper$$LOG;
    }

    public Tuple2<FileStatus[], scala.collection.immutable.Map<URI, PartitionColumnInfo[]>> listDeltaFiles(Path nonNormalizedPath, JobConf job) {
        long loadStartMs = System.currentTimeMillis();
        FileSystem fs = nonNormalizedPath.getFileSystem((Configuration)job);
        Path rootPath = fs.makeQualified(nonNormalizedPath);
        Snapshot snapshotToUse = this.loadDeltaLatestSnapshot((Configuration)job, rootPath);
        StructTypeInfo hiveSchema = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)job.get(DeltaStorageHandler$.MODULE$.DELTA_TABLE_SCHEMA()));
        this.checkTableSchema(snapshotToUse.getMetadata().getSchema(), hiveSchema);
        long blockSize = job.getLong("parquet.block.size", 0x8000000L);
        scala.collection.mutable.Map localFileToPartition = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set partitionColumns = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(snapshotToUse.getMetadata().getPartitionColumns()).asScala()).toSet();
        Tuple2[] partitionColumnWithIndex = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshotToUse.getMetadata().getSchema().getFields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DeltaHelper$.$anonfun$listDeltaFiles$1(partitionColumns, x0$1))))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
        Seq files = (Seq)this.prunePartitions(job.get("hive.io.filter.expr.serialized"), (Seq<StructField>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumnWithIndex)).map((Function1 & Serializable & scala.Serializable)x$2 -> (StructField)x$2._1(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), (Seq<AddFile>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(snapshotToUse.getAllFiles()).asScala()).toSeq()).map((Function1 & Serializable & scala.Serializable)addF -> {
            AddFile f = AddFile.builder((String)addF.getPath(), (java.util.Map)addF.getPartitionValues(), (long)addF.getSize(), (long)addF.getModificationTime(), (boolean)addF.isDataChange()).build();
            FileStatus status = MODULE$.toFileStatus(fs, rootPath, f, blockSize);
            localFileToPartition.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)status.getPath().toUri()), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumnWithIndex)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    StructField t = (StructField)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return new PartitionColumnInfo(index, t.getDataType().getCatalogString(), (String)f.getPartitionValues().get(t.getName()));
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PartitionColumnInfo.class)))));
            return status;
        }, Seq$.MODULE$.canBuildFrom());
        long loadEndMs = System.currentTimeMillis();
        this.logOperationDuration("fetching file list", rootPath, snapshotToUse, loadEndMs - loadStartMs);
        if (this.io$delta$hive$DeltaHelper$$LOG().isInfoEnabled()) {
            this.io$delta$hive$DeltaHelper$$LOG().info(new StringBuilder(48).append("Found ").append(files.size()).append(" files to process ").append("in the Delta Lake table ").append(this.hideUserInfoInPath(rootPath)).toString());
        }
        return new Tuple2(files.toArray(ClassTag$.MODULE$.apply(FileStatus.class)), (Object)localFileToPartition.toMap(Predef$.MODULE$.$conforms()));
    }

    public Seq<String> getPartitionCols(Configuration hadoopConf, Path rootPath) {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.loadDeltaLatestSnapshot(hadoopConf, rootPath).getMetadata().getPartitionColumns()).asScala()).toSeq();
    }

    public Snapshot loadDeltaLatestSnapshot(Configuration hadoopConf, Path rootPath) {
        long loadStartMs = System.currentTimeMillis();
        DeltaLog deltaLog = (DeltaLog)this.deltaLogCache().get((Object)rootPath, (Callable)new Callable<DeltaLog>(rootPath, hadoopConf){
            private final Path rootPath$2;
            private final Configuration hadoopConf$1;

            public DeltaLog call() {
                block0: {
                    if (!DeltaHelper$.MODULE$.io$delta$hive$DeltaHelper$$LOG().isInfoEnabled()) break block0;
                    DeltaHelper$.MODULE$.io$delta$hive$DeltaHelper$$LOG().info(new StringBuilder(52).append("DeltaLog for table ").append(this.rootPath$2.getName()).append(" was not cached. Loading log now.").toString());
                }
                return DeltaLog.forTable((Configuration)this.hadoopConf$1, (Path)this.rootPath$2);
            }
            {
                this.rootPath$2 = rootPath$2;
                this.hadoopConf$1 = hadoopConf$1;
            }
        });
        Snapshot snapshot = deltaLog.update();
        long loadEndMs = System.currentTimeMillis();
        this.logOperationDuration("loading log & snapshot", rootPath, snapshot, loadEndMs - loadStartMs);
        if (snapshot.getVersion() < 0L) {
            throw new MetaException(new StringBuilder(41).append(this.hideUserInfoInPath(rootPath)).append(" does not exist or it's not a Delta table").toString());
        }
        return snapshot;
    }

    public void checkTableSchema(StructType standaloneSchema, StructTypeInfo hiveSchema) throws MetaException {
        StructType standaloneType = (StructType)this.normalizeSparkType((DataType)standaloneSchema);
        StructType hiveType = (StructType)this.hiveTypeToSparkType((TypeInfo)hiveSchema);
        StructType structType = standaloneType;
        StructType structType2 = hiveType;
        if (structType == null ? structType2 != null : !structType.equals(structType2)) {
            Seq<String> diffs = SchemaUtils$.MODULE$.reportDifferences(standaloneType, hiveType);
            throw this.metaInconsistencyException(standaloneSchema, hiveSchema, diffs.mkString("\n"));
        }
    }

    private Cache<Path, DeltaLog> deltaLogCache() {
        return this.deltaLogCache;
    }

    private FileStatus toFileStatus(FileSystem fs, Path root, AddFile f, long blockSize) {
        FileStatus status = new FileStatus(f.getSize(), false, 1, blockSize, f.getModificationTime(), this.absolutePath(fs, root, f.getPath()));
        BlockLocation[] dummyBlockLocations = (BlockLocation[])((Object[])new BlockLocation[]{new BlockLocation((String[])((Object[])new String[]{"localhost:50010"}), (String[])((Object[])new String[]{"localhost"}), 0L, f.getSize())});
        return new LocatedFileStatus(status, dummyBlockLocations);
    }

    private Path absolutePath(FileSystem fs, Path root, String child) {
        Path p = new Path(new URI(child));
        if (p.isAbsolute()) {
            return fs.makeQualified(p);
        }
        return new Path(root, p);
    }

    private DataType normalizeSparkType(DataType sparkType) {
        DataType dataType = sparkType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.getFields())).map((Function1 & Serializable & scala.Serializable)f -> new StructField(f.getName().toLowerCase(Locale.ROOT), MODULE$.normalizeSparkType(f.getDataType())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return new ArrayType(this.normalizeSparkType(arrayType.getElementType()), true);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            return new MapType(this.normalizeSparkType(mapType.getKeyType()), this.normalizeSparkType(mapType.getValueType()), true);
        }
        return dataType;
    }

    private DataType hiveTypeToSparkType(TypeInfo hiveType) {
        TypeInfo typeInfo = hiveType;
        PrimitiveTypeInfo primitiveTypeInfo = TypeInfoFactory.byteTypeInfo;
        TypeInfo typeInfo2 = typeInfo;
        if (!(primitiveTypeInfo != null ? !primitiveTypeInfo.equals(typeInfo2) : typeInfo2 != null)) {
            return new ByteType();
        }
        PrimitiveTypeInfo primitiveTypeInfo2 = TypeInfoFactory.binaryTypeInfo;
        TypeInfo typeInfo3 = typeInfo;
        if (!(primitiveTypeInfo2 != null ? !primitiveTypeInfo2.equals(typeInfo3) : typeInfo3 != null)) {
            return new BinaryType();
        }
        PrimitiveTypeInfo primitiveTypeInfo3 = TypeInfoFactory.booleanTypeInfo;
        TypeInfo typeInfo4 = typeInfo;
        if (!(primitiveTypeInfo3 != null ? !primitiveTypeInfo3.equals(typeInfo4) : typeInfo4 != null)) {
            return new BooleanType();
        }
        PrimitiveTypeInfo primitiveTypeInfo4 = TypeInfoFactory.intTypeInfo;
        TypeInfo typeInfo5 = typeInfo;
        if (!(primitiveTypeInfo4 != null ? !primitiveTypeInfo4.equals(typeInfo5) : typeInfo5 != null)) {
            return new IntegerType();
        }
        PrimitiveTypeInfo primitiveTypeInfo5 = TypeInfoFactory.longTypeInfo;
        TypeInfo typeInfo6 = typeInfo;
        if (!(primitiveTypeInfo5 != null ? !primitiveTypeInfo5.equals(typeInfo6) : typeInfo6 != null)) {
            return new LongType();
        }
        PrimitiveTypeInfo primitiveTypeInfo6 = TypeInfoFactory.stringTypeInfo;
        TypeInfo typeInfo7 = typeInfo;
        if (!(primitiveTypeInfo6 != null ? !primitiveTypeInfo6.equals(typeInfo7) : typeInfo7 != null)) {
            return new StringType();
        }
        PrimitiveTypeInfo primitiveTypeInfo7 = TypeInfoFactory.floatTypeInfo;
        TypeInfo typeInfo8 = typeInfo;
        if (!(primitiveTypeInfo7 != null ? !primitiveTypeInfo7.equals(typeInfo8) : typeInfo8 != null)) {
            return new FloatType();
        }
        PrimitiveTypeInfo primitiveTypeInfo8 = TypeInfoFactory.doubleTypeInfo;
        TypeInfo typeInfo9 = typeInfo;
        if (!(primitiveTypeInfo8 != null ? !primitiveTypeInfo8.equals(typeInfo9) : typeInfo9 != null)) {
            return new DoubleType();
        }
        PrimitiveTypeInfo primitiveTypeInfo9 = TypeInfoFactory.shortTypeInfo;
        TypeInfo typeInfo10 = typeInfo;
        if (!(primitiveTypeInfo9 != null ? !primitiveTypeInfo9.equals(typeInfo10) : typeInfo10 != null)) {
            return new ShortType();
        }
        PrimitiveTypeInfo primitiveTypeInfo10 = TypeInfoFactory.dateTypeInfo;
        TypeInfo typeInfo11 = typeInfo;
        if (!(primitiveTypeInfo10 != null ? !primitiveTypeInfo10.equals(typeInfo11) : typeInfo11 != null)) {
            return new DateType();
        }
        PrimitiveTypeInfo primitiveTypeInfo11 = TypeInfoFactory.timestampTypeInfo;
        TypeInfo typeInfo12 = typeInfo;
        if (!(primitiveTypeInfo11 != null ? !primitiveTypeInfo11.equals(typeInfo12) : typeInfo12 != null)) {
            return new TimestampType();
        }
        if (typeInfo instanceof DecimalTypeInfo) {
            DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
            return new DecimalType(decimalTypeInfo.precision(), decimalTypeInfo.scale());
        }
        if (typeInfo instanceof ListTypeInfo) {
            ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
            return new ArrayType(this.hiveTypeToSparkType(listTypeInfo.getListElementTypeInfo()), true);
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            return new MapType(this.hiveTypeToSparkType(mapTypeInfo.getMapKeyTypeInfo()), this.hiveTypeToSparkType(mapTypeInfo.getMapValueTypeInfo()), true);
        }
        if (typeInfo instanceof StructTypeInfo) {
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            int size = structTypeInfo.getAllStructFieldNames().size();
            IndexedSeq fields = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).map((Function1 & Serializable & scala.Serializable)i -> DeltaHelper$.$anonfun$hiveTypeToSparkType$1(structTypeInfo, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            return new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class)));
        }
        throw new UnsupportedOperationException(new StringBuilder(27).append("Hive type ").append(hiveType).append(" is not supported").toString());
    }

    private MetaException metaInconsistencyException(StructType deltaSchema, StructTypeInfo hiveSchema, String diffs) {
        String hiveSchemaString = ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)hiveSchema.getAllStructFieldNames()).asScala()).zip((GenIterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)hiveSchema.getAllStructFieldTypeInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getTypeName(), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.productIterator().mkString(": "), Buffer$.MODULE$.canBuildFrom())).mkString("\n");
        return new MetaException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(270).append("The Delta table schema is not the same as the Hive schema:\n         |\n         |").append(diffs).append("\n         |\n         |Delta table schema:\n         |").append(deltaSchema.getTreeString()).append("\n         |\n         |Hive schema:\n         |").append(hiveSchemaString).append("\n         |\n         |Please update your Hive table's schema to match the Delta table schema.").toString())).stripMargin());
    }

    private void logOperationDuration(String ops, Path path, Snapshot snapshot, long durationMs) {
        if (this.io$delta$hive$DeltaHelper$$LOG().isInfoEnabled()) {
            this.io$delta$hive$DeltaHelper$$LOG().info(new StringBuilder(67).append("Delta Lake table '").append(this.hideUserInfoInPath(path)).append("' (").append("version: ").append(snapshot.getVersion()).append(", ").append("add: ").append(snapshot.getAllFiles().size()).append(", ").append("partitions: ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(snapshot.getMetadata().getPartitionColumns()).asScala()).mkString("[", ", ", "]")).append(") spent ").append(durationMs).append(" ms on ").append(ops).append(".").toString());
            return;
        }
    }

    private Path hideUserInfoInPath(Path path) {
        Path path2;
        try {
            URI uri = path.toUri();
            URI newUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            path2 = new Path(newUri);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                if (this.io$delta$hive$DeltaHelper$$LOG().isErrorEnabled()) {
                    this.io$delta$hive$DeltaHelper$$LOG().error(new StringBuilder(30).append("Path contains illegal format: ").append(path).toString(), e);
                }
                path2 = path;
            }
            throw throwable;
        }
        return path2;
    }

    private Seq<AddFile> prunePartitions(String serializedFilterExpr, Seq<StructField> partitionSchema, Seq<AddFile> addFiles) {
        if (serializedFilterExpr == null) {
            return addFiles;
        }
        ExprNodeGenericFuncDesc filterExprDesc = SerializationUtilities.deserializeExpression((String)serializedFilterExpr);
        return (Seq)addFiles.groupBy((Function1 & Serializable & scala.Serializable)addFile -> addFile.getPartitionValues()).filterKeys((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)DeltaHelper$.MODULE$.evalPartitionFilter(filterExprDesc, (scala.collection.immutable.Map<String, String>)((TraversableOnce)partitionSchema.map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), (Object)field.getDataType().getCatalogString()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), (Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(partition).asScala())))).values().toVector().flatten((Function1)Predef$.MODULE$.$conforms());
    }

    private boolean evalPartitionFilter(ExprNodeGenericFuncDesc filterExprDesc, scala.collection.immutable.Map<String, String> partitionSchema, Map<String, String> partitionValues) {
        int numPartitionColumns = partitionValues.size();
        Predef$.MODULE$.assert(numPartitionColumns == partitionSchema.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("the size (").append(partitionSchema.size()).append(") of the partition schema (").append(partitionSchema).append(") is not the ").append("same as the size (").append(numPartitionColumns).append(") of the partition values (").append(partitionValues).append(")").toString());
        ArrayList partNames = new ArrayList(numPartitionColumns);
        ArrayList partValues = new ArrayList(numPartitionColumns);
        ArrayList partObjectInspectors = new ArrayList(numPartitionColumns);
        partitionValues.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DeltaHelper$.$anonfun$evalPartitionFilter$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeltaHelper$.$anonfun$evalPartitionFilter$3(partitionSchema, partObjectInspectors, partValues, partNames, x$5)));
        StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        ExprNodeEvaluator filterExpr = ExprNodeEvaluatorFactory.get((ExprNodeDesc)filterExprDesc);
        ObjectInspector evaluatedResultOI = filterExpr.initialize((ObjectInspector)partObjectInspector);
        Object result = ((PrimitiveObjectInspector)evaluatedResultOI).getPrimitiveJavaObject(filterExpr.evaluate(partValues));
        if (this.io$delta$hive$DeltaHelper$$LOG().isDebugEnabled()) {
            this.io$delta$hive$DeltaHelper$$LOG().debug(new StringBuilder(24).append(filterExprDesc).append(" on partition ").append(partitionValues).append(" returned ").append(result).toString());
        }
        return BoxesRunTime.equals((Object)Boolean.TRUE, (Object)result);
    }

    public static final /* synthetic */ boolean $anonfun$listDeltaFiles$1(Set partitionColumns$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField t = (StructField)tuple2._1();
            return partitionColumns$1.contains((Object)t.getName());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ StructField $anonfun$hiveTypeToSparkType$1(StructTypeInfo x16$1, int i) {
        String hiveFieldName = (String)x16$1.getAllStructFieldNames().get(i);
        TypeInfo hiveFieldType = (TypeInfo)x16$1.getAllStructFieldTypeInfos().get(i);
        return new StructField(hiveFieldName.toLowerCase(Locale.ROOT), MODULE$.hiveTypeToSparkType(hiveFieldType));
    }

    public static final /* synthetic */ boolean $anonfun$evalPartitionFilter$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$evalPartitionFilter$3(scala.collection.immutable.Map partitionSchema$2, ArrayList partObjectInspectors$1, ArrayList partValues$1, ArrayList partNames$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            String partName = (String)tuple2._1();
            String partValue = (String)tuple2._2();
            AbstractPrimitiveWritableObjectInspector oi = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)((String)partitionSchema$2.apply((Object)partName))));
            partObjectInspectors$1.add(oi);
            partValues$1.add(ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)oi).convert((Object)partValue));
            return partNames$1.add(partName);
        }
        throw new MatchError((Object)tuple2);
    }

    private DeltaHelper$() {
        MODULE$ = this;
        this.io$delta$hive$DeltaHelper$$LOG = LoggerFactory.getLogger((String)this.getClass().getName());
        this.deltaLogCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).maximumSize(1L).build();
    }
}

