/*
 * Decompiled with CFR 0.152.
 */
package io.delta.hive;

import io.delta.hive.DeltaHelper$;
import io.delta.hive.DeltaInputSplit;
import io.delta.hive.DeltaRecordReaderWrapper;
import io.delta.hive.DeltaStorageHandler$;
import io.delta.hive.HiveInputFormat;
import io.delta.hive.PartitionColumnInfo;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001\u0002\t\u0012\u0001aA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006k\u0001!\tA\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019\u0011\u0005\u0001)A\u0005y!91\t\u0001a\u0001\n\u0013!\u0005bB1\u0001\u0001\u0004%IA\u0019\u0005\u0007Q\u0002\u0001\u000b\u0015B#\t\u000bU\u0002A\u0011A5\t\u000b)\u0004A\u0011I6\t\u000by\u0004A\u0011I@\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(!9\u00111\u0006\u0001\u0005\n\u00055\u0002bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003'\u0002A\u0011IA>\u0011\u001d\tI\t\u0001C!\u0003\u0017\u0013\u0001\u0003R3mi\u0006Le\u000e];u\r>\u0014X.\u0019;\u000b\u0005I\u0019\u0012\u0001\u00025jm\u0016T!\u0001F\u000b\u0002\u000b\u0011,G\u000e^1\u000b\u0003Y\t!![8\u0004\u0001M\u0011\u0001!\u0007\t\u00055\r*#&D\u0001\u001c\u0015\taR$\u0001\u0004nCB\u0014X\r\u001a\u0006\u0003=}\ta\u0001[1e_>\u0004(B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001eL!\u0001J\u000e\u0003\u001f\u0019KG.Z%oaV$hi\u001c:nCR\u0004\"A\n\u0015\u000e\u0003\u001dR!AF\u000f\n\u0005%:#\u0001\u0004(vY2<&/\u001b;bE2,\u0007C\u0001\u0014,\u0013\tasEA\u0007BeJ\f\u0017p\u0016:ji\u0006\u0014G.Z\u0001\ne\u0016\fG.\u00138qkR\u00042aL\u001a+\u001b\u0005\u0001$B\u0001\u00102\u0015\t\u0011t$A\u0004qCJ\fX/\u001a;\n\u0005Q\u0002$A\u0005)beF,X\r^%oaV$hi\u001c:nCR\fa\u0001P5oSRtDCA\u001c:!\tA\u0004!D\u0001\u0012\u0011\u0015i#\u00011\u0001/\u0003\raujR\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011q(I\u0001\u0006g24GG[\u0005\u0003\u0003z\u0012a\u0001T8hO\u0016\u0014\u0018\u0001\u0002'P\u000f\u0002\nqBZ5mKR{\u0007+\u0019:uSRLwN\\\u000b\u0002\u000bB!ai\u0014*[\u001d\t9U\n\u0005\u0002I\u00176\t\u0011J\u0003\u0002K/\u00051AH]8pizR\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u000ba\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\ri\u0015\r\u001d\u0006\u0003\u001d.\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u00079,GOC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&aA+S\u0013B\u00191\f\u00180\u000e\u0003-K!!X&\u0003\u000b\u0005\u0013(/Y=\u0011\u0005az\u0016B\u00011\u0012\u0005M\u0001\u0016M\u001d;ji&|gnQ8mk6t\u0017J\u001c4p\u0003M1\u0017\u000e\\3U_B\u000b'\u000f^5uS>tw\fJ3r)\t\u0019g\r\u0005\u0002\\I&\u0011Qm\u0013\u0002\u0005+:LG\u000fC\u0004h\r\u0005\u0005\t\u0019A#\u0002\u0007a$\u0013'\u0001\tgS2,Gk\u001c)beRLG/[8oAQ\tq'A\bhKR\u0014VmY8sIJ+\u0017\rZ3s)\u0011aw\u000e^=\u0011\tiiWEK\u0005\u0003]n\u0011ABU3d_J$'+Z1eKJDQ\u0001]\u0005A\u0002E\fQa\u001d9mSR\u0004\"A\u0007:\n\u0005M\\\"AC%oaV$8\u000b\u001d7ji\")Q/\u0003a\u0001m\u0006\u0019!n\u001c2\u0011\u0005i9\u0018B\u0001=\u001c\u0005\u001dQuNY\"p]\u001aDQA_\u0005A\u0002m\f\u0001B]3q_J$XM\u001d\t\u00035qL!!`\u000e\u0003\u0011I+\u0007o\u001c:uKJ\f!\u0002\\5tiN#\u0018\r^;t)\u0011\t\t!a\u0004\u0011\tmc\u00161\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\u000f\u0002\u0005\u0019\u001c\u0018\u0002BA\u0007\u0003\u000f\u0011!BR5mKN#\u0018\r^;t\u0011\u0015)(\u00021\u0001wQ\u0015Q\u00111CA\u0012!\u0015Y\u0016QCA\r\u0013\r\t9b\u0013\u0002\u0007i\"\u0014xn^:\u0011\t\u0005m\u0011qD\u0007\u0003\u0003;Q!A\u0006,\n\t\u0005\u0005\u0012Q\u0004\u0002\f\u0013>+\u0005pY3qi&|gn\t\u0002\u0002\u001a\u0005i1\r[3dW\"Kg/Z\"p]\u001a$2aYA\u0015\u0011\u0015)8\u00021\u0001w\u0003A!W\r\u001c;b\r>\u0014X.\u0019;FeJ|'\u000f\u0006\u0005\u00020\u0005\u0005\u00131JA(!\u0011\t\t$a\u000f\u000f\t\u0005M\u0012q\u0007\b\u0004\u0011\u0006U\u0012\"\u0001'\n\u0007\u0005e2*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0012q\b\u0002\n)\"\u0014xn^1cY\u0016T1!!\u000fL\u0011\u001d\t\u0019\u0005\u0004a\u0001\u0003\u000b\na!\u001a8hS:,\u0007c\u0001$\u0002H%\u0019\u0011\u0011J)\u0003\rM#(/\u001b8h\u0011\u001d\ti\u0005\u0004a\u0001\u0003\u000b\nABZ8s[\u0006$8i\u001c8gS\u001eDq!!\u0015\r\u0001\u0004\t)%A\u0006eK2$\u0018MR8s[\u0006$\u0018!C7bW\u0016\u001c\u0006\u000f\\5u))\t9&!\u0018\u0002h\u0005E\u0014Q\u000f\t\u00045\u0005e\u0013bAA.7\tIa)\u001b7f'Bd\u0017\u000e\u001e\u0005\b\u0003?j\u0001\u0019AA1\u0003\u00111\u0017\u000e\\3\u0011\t\u0005\u0015\u00111M\u0005\u0005\u0003K\n9A\u0001\u0003QCRD\u0007bBA5\u001b\u0001\u0007\u00111N\u0001\u0006gR\f'\u000f\u001e\t\u00047\u00065\u0014bAA8\u0017\n!Aj\u001c8h\u0011\u001d\t\u0019(\u0004a\u0001\u0003W\na\u0001\\3oORD\u0007bBA<\u001b\u0001\u0007\u0011\u0011P\u0001\u0006Q>\u001cHo\u001d\t\u00057r\u000b)\u0005\u0006\u0007\u0002X\u0005u\u0014qPAA\u0003\u0007\u000b)\tC\u0004\u0002`9\u0001\r!!\u0019\t\u000f\u0005%d\u00021\u0001\u0002l!9\u00111\u000f\bA\u0002\u0005-\u0004bBA<\u001d\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u000fs\u0001\u0019AA=\u00035Ig.T3n_JL\bj\\:ug\u0006Iq-\u001a;Ta2LGo\u001d\u000b\u0007\u0003\u001b\u000by)!%\u0011\u0007mc\u0016\u000fC\u0003v\u001f\u0001\u0007a\u000fC\u0004\u0002\u0014>\u0001\r!!&\u0002\u00139,Xn\u00159mSR\u001c\bcA.\u0002\u0018&\u0019\u0011\u0011T&\u0003\u0007%sG\u000f")
public class DeltaInputFormat
extends FileInputFormat<NullWritable, ArrayWritable> {
    private final ParquetInputFormat<ArrayWritable> realInput;
    private final Logger LOG;
    private Map<URI, PartitionColumnInfo[]> fileToPartition;

    private Logger LOG() {
        return this.LOG;
    }

    private Map<URI, PartitionColumnInfo[]> fileToPartition() {
        return this.fileToPartition;
    }

    private void fileToPartition_$eq(Map<URI, PartitionColumnInfo[]> x$1) {
        this.fileToPartition = x$1;
    }

    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) {
        InputSplit inputSplit = split;
        if (inputSplit instanceof DeltaInputSplit) {
            DeltaInputSplit deltaInputSplit = (DeltaInputSplit)inputSplit;
            return new DeltaRecordReaderWrapper(this.realInput, deltaInputSplit, job, reporter);
        }
        throw new IllegalArgumentException(new StringBuilder(37).append("Expected DeltaInputSplit but it was: ").append(split).toString());
    }

    public FileStatus[] listStatus(JobConf job) throws IOException {
        this.checkHiveConf(job);
        Path deltaRootPath = new Path(job.get(DeltaStorageHandler$.MODULE$.DELTA_TABLE_PATH()));
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])((Path[])((Object[])new Path[]{deltaRootPath})), (Configuration)job);
        Tuple2 tuple2 = DeltaInputFormat.liftedTree1$1(deltaRootPath, job);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileStatus[] files = (FileStatus[])tuple2._1();
        Map partitions = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)files, (Object)partitions);
        FileStatus[] files2 = (FileStatus[])tuple22._1();
        Map partitions2 = (Map)tuple22._2();
        this.fileToPartition_$eq((Map<URI, PartitionColumnInfo[]>)((Map)partitions2.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeltaInputFormat.$anonfun$listStatus$1(x$2)))));
        return files2;
    }

    private void checkHiveConf(JobConf job) {
        String engine = HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
        String deltaFormat = HiveInputFormat.class.getName();
        String string = engine;
        if ("mr".equals(string)) {
            String string2 = HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEINPUTFORMAT);
            String string3 = deltaFormat;
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                throw this.deltaFormatError(engine, HiveConf.ConfVars.HIVEINPUTFORMAT.varname, deltaFormat);
            }
            return;
        }
        if ("tez".equals(string)) {
            String string4 = HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZINPUTFORMAT);
            String string5 = deltaFormat;
            if (string4 == null ? string5 != null : !string4.equals(string5)) {
                throw this.deltaFormatError(engine, HiveConf.ConfVars.HIVETEZINPUTFORMAT.varname, deltaFormat);
            }
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder(72).append("The execution engine '").append(string).append("' is not supported.").append(" Please set '").append(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname).append("' to 'mr' or 'tez'").toString());
    }

    private Throwable deltaFormatError(String engine, String formatConfig, String deltaFormat) {
        String message = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(397).append("'").append(formatConfig).append("' must be set to '").append(deltaFormat).append("' when reading a Delta table using\n         |'").append(engine).append("' execution engine. You can run the following SQL command in Hive CLI\n         |before reading a Delta table,\n         |\n         |> SET ").append(formatConfig).append("=").append(deltaFormat).append(";\n         |\n         |or add the following config to the \"hive-site.xml\" file.\n         |\n         |<property>\n         |  <name>").append(formatConfig).append("</name>\n         |  <value>").append(deltaFormat).append("</value>\n         |</property>\n      ").toString())).stripMargin();
        return new IllegalArgumentException(message);
    }

    public FileSplit makeSplit(Path file, long start, long length, String[] hosts) {
        return new DeltaInputSplit(file, start, length, hosts, (PartitionColumnInfo[])this.fileToPartition().getOrElse((Object)file.toUri(), (Function0 & Serializable & scala.Serializable)() -> (PartitionColumnInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(PartitionColumnInfo.class))));
    }

    public FileSplit makeSplit(Path file, long start, long length, String[] hosts, String[] inMemoryHosts) {
        return new DeltaInputSplit(file, start, length, hosts, inMemoryHosts, (PartitionColumnInfo[])this.fileToPartition().getOrElse((Object)file.toUri(), (Function0 & Serializable & scala.Serializable)() -> (PartitionColumnInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(PartitionColumnInfo.class))));
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) {
        InputSplit[] splits = super.getSplits(job, numSplits);
        this.fileToPartition_$eq((Map<URI, PartitionColumnInfo[]>)Predef$.MODULE$.Map().empty());
        return splits;
    }

    private static final /* synthetic */ Tuple2 liftedTree1$1(Path deltaRootPath$1, JobConf job$1) {
        Tuple2<FileStatus[], Map<URI, PartitionColumnInfo[]>> tuple2;
        try {
            tuple2 = DeltaHelper$.MODULE$.listDeltaFiles(deltaRootPath$1, job$1);
        }
        catch (MetaException e) {
            throw new IOException(e);
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$listStatus$1(Tuple2 x$2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2._2())).nonEmpty();
    }

    public DeltaInputFormat(ParquetInputFormat<ArrayWritable> realInput) {
        this.realInput = realInput;
        this.LOG = LoggerFactory.getLogger(DeltaInputFormat.class);
        this.fileToPartition = Predef$.MODULE$.Map().empty();
    }

    public DeltaInputFormat() {
        this((ParquetInputFormat<ArrayWritable>)new ParquetInputFormat(DataWritableReadSupport.class));
    }
}

