/*
 * Decompiled with CFR 0.152.
 */
package io.delta.hive;

import io.delta.hive.PartitionColumnInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;

public class DeltaInputSplit
extends FileSplit {
    private PartitionColumnInfo[] partitionColumns;

    protected DeltaInputSplit() {
        this.partitionColumns = new PartitionColumnInfo[0];
    }

    public DeltaInputSplit(Path path, long l, long l2, String[] stringArray, PartitionColumnInfo[] partitionColumnInfoArray) {
        super(path, l, l2, stringArray);
        this.partitionColumns = partitionColumnInfoArray;
    }

    public DeltaInputSplit(Path path, long l, long l2, String[] stringArray, String[] stringArray2, PartitionColumnInfo[] partitionColumnInfoArray) {
        super(path, l, l2, stringArray, stringArray2);
        this.partitionColumns = partitionColumnInfoArray;
    }

    public PartitionColumnInfo[] getPartitionColumns() {
        return this.partitionColumns;
    }

    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeInt(this.partitionColumns.length);
        for (PartitionColumnInfo partitionColumnInfo : this.partitionColumns) {
            partitionColumnInfo.write(dataOutput);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        super.readFields(dataInput);
        int n = dataInput.readInt();
        this.partitionColumns = new PartitionColumnInfo[n];
        for (int i = 0; i < n; ++i) {
            PartitionColumnInfo partitionColumnInfo = new PartitionColumnInfo();
            partitionColumnInfo.readFields(dataInput);
            this.partitionColumns[i] = partitionColumnInfo;
        }
    }
}

