/*
 * Decompiled with CFR 0.152.
 */
package io.delta.hive;

import io.delta.hive.CaseInsensitiveMap$;
import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.MapType;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$ = new SchemaUtils$();

    public Seq<String> reportDifferences(StructType existingSchema, StructType specifiedSchema) {
        return this.structDifference$1(existingSchema, specifiedSchema, "");
    }

    private Map<String, StructField> toFieldMap(Seq<StructField> fields) {
        return CaseInsensitiveMap$.MODULE$.apply(((IterableOnceOps)fields.map((Function1 & Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), field))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private static final String canOrNot$1(boolean can) {
        return can ? "can" : "can not";
    }

    private static final String isOrNon$1(boolean b) {
        return b ? "" : "non-";
    }

    private static final String missingFieldsMessage$1(scala.collection.immutable.Set fields) {
        return new StringBuilder(38).append("Specified schema is missing field(s): ").append(fields.mkString(", ")).toString();
    }

    private static final String additionalFieldsMessage$1(scala.collection.immutable.Set fields) {
        return new StringBuilder(42).append("Specified schema has additional field(s): ").append(fields.mkString(", ")).toString();
    }

    private static final String fieldNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(0).append(new StringBuilder(32).append("Field ").append(field).append(" is ").append(SchemaUtils$.isOrNon$1(specified)).append("nullable in specified ").toString()).append(new StringBuilder(39).append("schema but ").append(SchemaUtils$.isOrNon$1(existing)).append("nullable in existing schema.").toString()).toString();
    }

    private static final String arrayNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(0).append(new StringBuilder(47).append("Array field ").append(field).append(" ").append(SchemaUtils$.canOrNot$1(specified)).append(" contain null in specified schema ").toString()).append(new StringBuilder(23).append("but ").append(SchemaUtils$.canOrNot$1(existing)).append(" in existing schema").toString()).toString();
    }

    private static final String valueNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(0).append(new StringBuilder(52).append("Map field ").append(field).append(" ").append(SchemaUtils$.canOrNot$1(specified)).append(" contain null values in specified schema ").toString()).append(new StringBuilder(23).append("but ").append(SchemaUtils$.canOrNot$1(existing)).append(" in existing schema").toString()).toString();
    }

    private static final String typeDifferenceMessage$1(String field, DataType specified, DataType existing) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(98).append("Specified type for ").append(field).append(" is different from existing schema:\n         |Specified: ").append(specified.getTypeName()).append("\n         |Existing:  ").append(existing.getTypeName()).toString()));
    }

    private final Seq structDifference$1(StructType existing, StructType specified, String prefix) {
        scala.collection.immutable.Set specifiedFieldNames;
        scala.collection.immutable.Set existingFieldNames = Predef$.MODULE$.wrapRefArray((Object[])existing.getFieldNames()).toSet();
        scala.collection.immutable.Set missingFields = (scala.collection.immutable.Set)existingFieldNames.diff((Set)(specifiedFieldNames = Predef$.MODULE$.wrapRefArray((Object[])specified.getFieldNames()).toSet()));
        Nil$ missingFieldsDiffs = missingFields.isEmpty() ? package$.MODULE$.Nil() : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.missingFieldsMessage$1((scala.collection.immutable.Set)missingFields.map((Function1 & Serializable)x$1 -> new StringBuilder(0).append(prefix).append((String)x$1).toString()))}));
        scala.collection.immutable.Set extraFields = (scala.collection.immutable.Set)specifiedFieldNames.diff((Set)existingFieldNames);
        Nil$ extraFieldsDiffs = extraFields.isEmpty() ? package$.MODULE$.Nil() : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.additionalFieldsMessage$1((scala.collection.immutable.Set)extraFields.map((Function1 & Serializable)x$2 -> new StringBuilder(0).append(prefix).append((String)x$2).toString()))}));
        boolean columnsOutOfOrder = missingFields.isEmpty() && extraFields.isEmpty() && !Predef$.MODULE$.wrapRefArray((Object[])existing.getFieldNames()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])specified.getFieldNames()));
        Nil$ columnsOutOfOrderMsg = columnsOutOfOrder ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Columns out of order"})) : package$.MODULE$.Nil();
        Map<String, StructField> existingFields = this.toFieldMap((Seq<StructField>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)existing.getFields()));
        Map<String, StructField> specifiedFields = this.toFieldMap((Seq<StructField>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)specified.getFields()));
        scala.collection.immutable.Set fieldsDiffs = (scala.collection.immutable.Set)existingFieldNames.intersect((Set)specifiedFieldNames).flatMap((Function1 & Serializable)name -> this.fieldDifference$1((StructField)existingFields.apply(name), (StructField)specifiedFields.apply(name), prefix));
        return (Seq)((IterableOps)((IterableOps)missingFieldsDiffs.$plus$plus((IterableOnce)extraFieldsDiffs)).$plus$plus((IterableOnce)fieldsDiffs)).$plus$plus((IterableOnce)columnsOutOfOrderMsg);
    }

    private final Seq fieldDifference$1(StructField existing, StructField specified, String prefix) {
        String name = new StringBuilder(0).append(prefix).append(existing.getName()).toString();
        Nil$ nullabilityDiffs = existing.isNullable() == specified.isNullable() ? package$.MODULE$.Nil() : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.fieldNullabilityMessage$1(String.valueOf(name), specified.isNullable(), existing.isNullable())}));
        Seq typeDiffs = this.typeDifference$1(existing.getDataType(), specified.getDataType(), name);
        return (Seq)nullabilityDiffs.$plus$plus((IterableOnce)typeDiffs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Seq typeDifference$1(DataType existing, DataType specified, String field) {
        Tuple2 tuple2 = new Tuple2((Object)existing, (Object)specified);
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof StructType) {
                StructType structType = (StructType)e;
                if (s instanceof StructType) {
                    StructType structType2 = (StructType)s;
                    return this.structDifference$1(structType, structType2, new StringBuilder(1).append(field).append(".").toString());
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)e;
                if (s instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)s;
                    return this.arrayDifference$1(arrayType, arrayType2, new StringBuilder(2).append(field).append("[]").toString());
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof MapType) {
                MapType mapType = (MapType)e;
                if (s instanceof MapType) {
                    MapType mapType2 = (MapType)s;
                    return this.mapDifference$1(mapType, mapType2, String.valueOf(field));
                }
            }
        }
        if (tuple2 == null) return package$.MODULE$.Nil();
        DataType e = (DataType)tuple2._1();
        DataType s = (DataType)tuple2._2();
        DataType dataType = e;
        DataType dataType2 = s;
        if (dataType == null) {
            if (dataType2 == null) return package$.MODULE$.Nil();
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.typeDifferenceMessage$1(field, s, e)}));
        } else if (dataType.equals(dataType2)) return package$.MODULE$.Nil();
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.typeDifferenceMessage$1(field, s, e)}));
    }

    private final Seq arrayDifference$1(ArrayType existing, ArrayType specified, String field) {
        Seq elementDiffs = this.typeDifference$1(existing.getElementType(), specified.getElementType(), field);
        Nil$ nullabilityDiffs = existing.containsNull() == specified.containsNull() ? package$.MODULE$.Nil() : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.arrayNullabilityMessage$1(field, specified.containsNull(), existing.containsNull())}));
        return (Seq)elementDiffs.$plus$plus((IterableOnce)nullabilityDiffs);
    }

    private final Seq mapDifference$1(MapType existing, MapType specified, String field) {
        Seq keyDiffs = this.typeDifference$1(existing.getKeyType(), specified.getKeyType(), new StringBuilder(5).append(field).append("[key]").toString());
        Seq valueDiffs = this.typeDifference$1(existing.getValueType(), specified.getValueType(), new StringBuilder(7).append(field).append("[value]").toString());
        Nil$ nullabilityDiffs = existing.valueContainsNull() == specified.valueContainsNull() ? package$.MODULE$.Nil() : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.valueNullabilityMessage$1(field, specified.valueContainsNull(), existing.valueContainsNull())}));
        return (Seq)((IterableOps)keyDiffs.$plus$plus((IterableOnce)valueDiffs)).$plus$plus((IterableOnce)nullabilityDiffs);
    }

    private SchemaUtils$() {
    }
}

