/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.client.FileReadContext;
import io.delta.kernel.client.ParquetHandler;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FileDataReadResult;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.AlwaysTrue;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.data.ScanStateRow;
import io.delta.kernel.internal.data.SelectionColumnVector;
import io.delta.kernel.internal.deletionvectors.DeletionVectorUtils;
import io.delta.kernel.internal.deletionvectors.RoaringBitmapArray;
import io.delta.kernel.internal.util.PartitionUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

@Evolving
public interface Scan {
    public CloseableIterator<FilteredColumnarBatch> getScanFiles(TableClient var1);

    public Optional<Predicate> getRemainingFilter();

    public Row getScanState(TableClient var1);

    public static CloseableIterator<FilteredColumnarBatch> readData(final TableClient tableClient, final Row row, CloseableIterator<Row> closeableIterator, Optional<Predicate> optional) throws IOException {
        final StructType structType = ScanStateRow.getPhysicalSchema(tableClient, row);
        final StructType structType2 = ScanStateRow.getLogicalSchema(tableClient, row);
        List<String> list = ScanStateRow.getPartitionColumns(row);
        HashSet<String> hashSet = new HashSet<String>(list);
        final StructType structType3 = PartitionUtils.physicalSchemaWithoutPartitionColumns(structType2, structType, hashSet);
        StructType structType4 = structType3.add(StructField.METADATA_ROW_INDEX_COLUMN);
        ParquetHandler parquetHandler = tableClient.getParquetHandler();
        CloseableIterator<FileReadContext> closeableIterator2 = parquetHandler.contextualizeFileReads(closeableIterator, optional.orElse(AlwaysTrue.ALWAYS_TRUE));
        final CloseableIterator<FileDataReadResult> closeableIterator3 = parquetHandler.readParquetFiles(closeableIterator2, structType4);
        final String string = ScanStateRow.getTableRoot(row);
        return new CloseableIterator<FilteredColumnarBatch>(){
            RoaringBitmapArray currBitmap = null;
            DeletionVectorDescriptor currDV = null;

            @Override
            public void close() throws IOException {
                closeableIterator3.close();
            }

            @Override
            public boolean hasNext() {
                return closeableIterator3.hasNext();
            }

            @Override
            public FilteredColumnarBatch next() {
                String string2;
                Object object;
                Optional<ColumnVector> optional;
                FileDataReadResult fileDataReadResult = (FileDataReadResult)closeableIterator3.next();
                Row row2 = fileDataReadResult.getScanFileRow();
                DeletionVectorDescriptor deletionVectorDescriptor = InternalScanFileUtils.getDeletionVectorDescriptorFromRow(row2);
                int n = fileDataReadResult.getData().getSchema().indexOf(StructField.METADATA_ROW_INDEX_COLUMN_NAME);
                if (deletionVectorDescriptor == null) {
                    optional = Optional.empty();
                } else {
                    if (!deletionVectorDescriptor.equals(this.currDV)) {
                        object = DeletionVectorUtils.loadNewDvAndBitmap(tableClient, string, deletionVectorDescriptor);
                        this.currDV = (DeletionVectorDescriptor)((Tuple2)object)._1;
                        this.currBitmap = (RoaringBitmapArray)((Tuple2)object)._2;
                    }
                    object = fileDataReadResult.getData().getColumnVector(n);
                    optional = Optional.of(new SelectionColumnVector(this.currBitmap, (ColumnVector)object));
                }
                object = fileDataReadResult.getData().withDeletedColumnAt(n);
                object = PartitionUtils.withPartitionColumns(tableClient.getExpressionHandler(), object, structType3, InternalScanFileUtils.getPartitionValues(fileDataReadResult.getScanFileRow()), structType);
                switch (string2 = ScanStateRow.getColumnMappingMode(row)) {
                    case "name": {
                        object = object.withNewSchema(structType2);
                        break;
                    }
                    case "none": {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Column mapping mode is not yet supported: " + string2);
                    }
                }
                return new FilteredColumnarBatch((ColumnarBatch)object, optional);
            }
        };
    }
}

