/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Scan;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.expressions.PredicateEvaluator;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.data.ScanStateRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.internal.types.TableSchemaSerDe;
import io.delta.kernel.internal.util.InternalSchemaUtils;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.PartitionUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ScanImpl
implements Scan {
    private final StructType snapshotSchema;
    private final Path dataPath;
    private final StructType readSchema;
    private final CloseableIterator<FilteredColumnarBatch> filesIter;
    private final Lazy<Tuple2<Protocol, Metadata>> protocolAndMetadata;
    private final Lazy<Optional<Tuple2<Predicate, Predicate>>> partitionAndDataFilters;
    private final Lazy<Set<String>> partitionColumnNames;
    private boolean accessedScanFiles;

    public ScanImpl(StructType structType, StructType structType2, Lazy<Tuple2<Protocol, Metadata>> lazy, CloseableIterator<FilteredColumnarBatch> closeableIterator, Optional<Predicate> optional, Path path) {
        this.snapshotSchema = structType;
        this.readSchema = structType2;
        this.protocolAndMetadata = lazy;
        this.filesIter = closeableIterator;
        this.dataPath = path;
        this.partitionAndDataFilters = new Lazy<Optional>(() -> this.splitFilters(optional));
        this.partitionColumnNames = new Lazy<Set>(() -> this.loadPartitionColNames());
    }

    @Override
    public CloseableIterator<FilteredColumnarBatch> getScanFiles(TableClient tableClient) {
        if (this.accessedScanFiles) {
            throw new IllegalStateException("Scan files are already fetched from this instance");
        }
        this.accessedScanFiles = true;
        return this.applyPartitionPruning(tableClient, this.filesIter);
    }

    @Override
    public Row getScanState(TableClient tableClient) {
        return ScanStateRow.of((Metadata)this.protocolAndMetadata.get()._2, (Protocol)this.protocolAndMetadata.get()._1, TableSchemaSerDe.toJson(this.readSchema), TableSchemaSerDe.toJson(InternalSchemaUtils.convertToPhysicalSchema(this.readSchema, this.snapshotSchema, ((Metadata)this.protocolAndMetadata.get()._2).getConfiguration().getOrDefault("delta.columnMapping.mode", "none"))), this.dataPath.toUri().toString());
    }

    @Override
    public Optional<Predicate> getRemainingFilter() {
        return this.getDataFilters();
    }

    private Optional<Tuple2<Predicate, Predicate>> splitFilters(Optional<Predicate> optional) {
        return optional.map(predicate -> PartitionUtils.splitMetadataAndDataPredicates(predicate, this.partitionColumnNames.get()));
    }

    private Optional<Predicate> getDataFilters() {
        return this.removeAlwaysTrue(this.partitionAndDataFilters.get().map(tuple2 -> (Predicate)tuple2._2));
    }

    private Optional<Predicate> getPartitionsFilters() {
        return this.removeAlwaysTrue(this.partitionAndDataFilters.get().map(tuple2 -> (Predicate)tuple2._1));
    }

    private Optional<Predicate> removeAlwaysTrue(Optional<Predicate> optional) {
        return optional.filter(predicate -> !predicate.getName().equalsIgnoreCase("ALWAYS_TRUE"));
    }

    private CloseableIterator<FilteredColumnarBatch> applyPartitionPruning(TableClient tableClient, CloseableIterator<FilteredColumnarBatch> closeableIterator) {
        Optional<Predicate> optional = this.getPartitionsFilters();
        if (!optional.isPresent()) {
            return closeableIterator;
        }
        Metadata metadata = (Metadata)this.protocolAndMetadata.get()._2;
        Set<String> set = this.partitionColumnNames.get();
        Map<String, DataType> map = metadata.getSchema().fields().stream().filter(structField -> set.contains(structField.getName())).collect(Collectors.toMap(structField -> structField.getName().toLowerCase(Locale.ENGLISH), structField -> structField.getDataType()));
        Predicate predicate = PartitionUtils.rewritePartitionPredicateOnScanFileSchema(optional.get(), map);
        PredicateEvaluator predicateEvaluator = tableClient.getExpressionHandler().getPredicateEvaluator(InternalScanFileUtils.SCAN_FILE_SCHEMA, predicate);
        return this.filesIter.map(filteredColumnarBatch -> {
            ColumnVector columnVector = predicateEvaluator.eval(filteredColumnarBatch.getData(), filteredColumnarBatch.getSelectionVector());
            return new FilteredColumnarBatch(filteredColumnarBatch.getData(), Optional.of(columnVector));
        });
    }

    private Set<String> loadPartitionColNames() {
        Metadata metadata = (Metadata)this.protocolAndMetadata.get()._2;
        ArrayValue arrayValue = metadata.getPartitionColumns();
        ColumnVector columnVector = arrayValue.getElements();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < arrayValue.getSize(); ++i) {
            InternalUtils.checkArgument(!columnVector.isNullAt(i), "Expected a non-null partition column name");
            String string = columnVector.getString(i);
            InternalUtils.checkArgument(string != null && !string.isEmpty(), "Expected non-null and non-empty partition column name");
            hashSet.add(string.toLowerCase(Locale.ENGLISH));
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

