/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.ScanBuilder;
import io.delta.kernel.Snapshot;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.internal.ScanBuilderImpl;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.StructType;

public class SnapshotImpl
implements Snapshot {
    private final Path dataPath;
    private final long version;
    private final LogReplay logReplay;
    private final Lazy<Tuple2<Protocol, Metadata>> protocolAndMetadata;

    public SnapshotImpl(Path path, Path path2, long l, LogSegment logSegment, TableClient tableClient, long l2) {
        this.dataPath = path2;
        this.version = l;
        this.logReplay = new LogReplay(path, path2, tableClient, logSegment);
        this.protocolAndMetadata = new Lazy<Tuple2>(this.logReplay::loadProtocolAndMetadata);
    }

    @Override
    public long getVersion(TableClient tableClient) {
        return this.version;
    }

    @Override
    public StructType getSchema(TableClient tableClient) {
        return this.getMetadata().getSchema();
    }

    @Override
    public ScanBuilder getScanBuilder(TableClient tableClient) {
        return new ScanBuilderImpl(this.dataPath, this.protocolAndMetadata, this.getSchema(tableClient), this.logReplay.getAddFilesAsColumnarBatches(), tableClient);
    }

    public Metadata getMetadata() {
        return (Metadata)this.protocolAndMetadata.get()._2;
    }

    public Protocol getProtocol() {
        return (Protocol)this.protocolAndMetadata.get()._1;
    }
}

