/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.internal.actions.Format;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.internal.types.TableSchemaSerDe;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Metadata {
    public static final StructType READ_SCHEMA = new StructType().add("id", (DataType)StringType.STRING, false).add("name", (DataType)StringType.STRING, true).add("description", (DataType)StringType.STRING, true).add("format", (DataType)Format.READ_SCHEMA, false).add("schemaString", (DataType)StringType.STRING, false).add("partitionColumns", (DataType)new ArrayType(StringType.STRING, false), false).add("createdTime", (DataType)LongType.LONG, true).add("configuration", (DataType)new MapType(StringType.STRING, StringType.STRING, false), false);
    private final String id;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Format format;
    private final String schemaString;
    private final StructType schema;
    private final ArrayValue partitionColumns;
    private final Optional<Long> createdTime;
    private final MapValue configurationMapValue;
    private final Lazy<Map<String, String>> configuration;

    public static Metadata fromColumnVector(ColumnVector columnVector, int n, TableClient tableClient) {
        if (columnVector.isNullAt(n)) {
            return null;
        }
        String string = InternalUtils.requireNonNull(columnVector.getChild(4), n, "schemaString").getString(n);
        StructType structType = TableSchemaSerDe.fromJson(tableClient.getJsonHandler(), string);
        return new Metadata(InternalUtils.requireNonNull(columnVector.getChild(0), n, "id").getString(n), Optional.ofNullable(columnVector.getChild(1).isNullAt(n) ? null : columnVector.getChild(1).getString(n)), Optional.ofNullable(columnVector.getChild(2).isNullAt(n) ? null : columnVector.getChild(2).getString(n)), Format.fromColumnVector(InternalUtils.requireNonNull(columnVector.getChild(3), n, "format"), n), string, structType, columnVector.getChild(5).getArray(n), Optional.ofNullable(columnVector.getChild(6).isNullAt(n) ? null : Long.valueOf(columnVector.getChild(6).getLong(n))), columnVector.getChild(7).getMap(n));
    }

    public Metadata(String string, Optional<String> optional, Optional<String> optional2, Format format, String string2, StructType structType, ArrayValue arrayValue, Optional<Long> optional3, MapValue mapValue) {
        this.id = Objects.requireNonNull(string, "id is null");
        this.name = optional;
        this.description = Objects.requireNonNull(optional2, "description is null");
        this.format = Objects.requireNonNull(format, "format is null");
        this.schemaString = Objects.requireNonNull(string2, "schemaString is null");
        this.schema = structType;
        this.partitionColumns = Objects.requireNonNull(arrayValue, "partitionColumns is null");
        this.createdTime = optional3;
        this.configurationMapValue = Objects.requireNonNull(mapValue, "configuration is null");
        this.configuration = new Lazy<Map>(() -> VectorUtils.toJavaMap(mapValue));
    }

    public String getSchemaString() {
        return this.schemaString;
    }

    public StructType getSchema() {
        return this.schema;
    }

    public ArrayValue getPartitionColumns() {
        return this.partitionColumns;
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Format getFormat() {
        return this.format;
    }

    public Optional<Long> getCreatedTime() {
        return this.createdTime;
    }

    public MapValue getConfigurationMapValue() {
        return this.configurationMapValue;
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration.get());
    }
}

