/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.types.TableSchemaSerDe;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ScanStateRow
extends GenericRow {
    private static final StructType SCHEMA = new StructType().add("configuration", new MapType(StringType.STRING, StringType.STRING, false)).add("logicalSchemaString", StringType.STRING).add("physicalSchemaString", StringType.STRING).add("partitionColumns", new ArrayType(StringType.STRING, false)).add("minReaderVersion", IntegerType.INTEGER).add("minWriterVersion", IntegerType.INTEGER).add("tablePath", StringType.STRING);
    private static final Map<String, Integer> COL_NAME_TO_ORDINAL = IntStream.range(0, SCHEMA.length()).boxed().collect(Collectors.toMap(n -> SCHEMA.at((int)n).getName(), n -> n));

    public static ScanStateRow of(Metadata metadata, Protocol protocol, String string, String string2, String string3) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(COL_NAME_TO_ORDINAL.get("configuration"), metadata.getConfigurationMapValue());
        hashMap.put(COL_NAME_TO_ORDINAL.get("logicalSchemaString"), string);
        hashMap.put(COL_NAME_TO_ORDINAL.get("physicalSchemaString"), string2);
        hashMap.put(COL_NAME_TO_ORDINAL.get("partitionColumns"), metadata.getPartitionColumns());
        hashMap.put(COL_NAME_TO_ORDINAL.get("minReaderVersion"), protocol.getMinReaderVersion());
        hashMap.put(COL_NAME_TO_ORDINAL.get("minWriterVersion"), protocol.getMinWriterVersion());
        hashMap.put(COL_NAME_TO_ORDINAL.get("tablePath"), string3);
        return new ScanStateRow(hashMap);
    }

    public ScanStateRow(HashMap<Integer, Object> hashMap) {
        super(SCHEMA, hashMap);
    }

    public static StructType getLogicalSchema(TableClient tableClient, Row row) {
        String string = row.getString(COL_NAME_TO_ORDINAL.get("logicalSchemaString"));
        return TableSchemaSerDe.fromJson(tableClient.getJsonHandler(), string);
    }

    public static StructType getPhysicalSchema(TableClient tableClient, Row row) {
        String string = row.getString(COL_NAME_TO_ORDINAL.get("physicalSchemaString"));
        return TableSchemaSerDe.fromJson(tableClient.getJsonHandler(), string);
    }

    public static List<String> getPartitionColumns(Row row) {
        return VectorUtils.toJavaList(row.getArray(COL_NAME_TO_ORDINAL.get("partitionColumns")));
    }

    public static String getColumnMappingMode(Row row) {
        Map map = VectorUtils.toJavaMap(row.getMap(COL_NAME_TO_ORDINAL.get("configuration")));
        return map.getOrDefault("delta.columnMapping.mode", "none");
    }

    public static String getTableRoot(Row row) {
        return row.getString(COL_NAME_TO_ORDINAL.get("tablePath"));
    }
}

