/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.deletionvectors;

import io.delta.kernel.client.FileReadRequest;
import io.delta.kernel.client.FileSystemClient;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.deletionvectors.RoaringBitmapArray;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.zip.CRC32;

public class DeletionVectorStoredBitmap {
    private final DeletionVectorDescriptor dvDescriptor;
    private final Optional<String> tableDataPath;

    public DeletionVectorStoredBitmap(DeletionVectorDescriptor deletionVectorDescriptor, Optional<String> optional) {
        InternalUtils.checkArgument(optional.isPresent() || !deletionVectorDescriptor.isOnDisk(), "Table path is required for on-disk deletion vectors");
        this.dvDescriptor = deletionVectorDescriptor;
        this.tableDataPath = optional;
    }

    public RoaringBitmapArray load(FileSystemClient fileSystemClient) throws IOException {
        if (this.dvDescriptor.getCardinality() == 0L) {
            return new RoaringBitmapArray();
        }
        if (this.dvDescriptor.isInline()) {
            return RoaringBitmapArray.readFrom(this.dvDescriptor.inlineData());
        }
        final String string = this.dvDescriptor.getAbsolutePath(this.tableDataPath.get());
        FileReadRequest fileReadRequest = new FileReadRequest(){

            @Override
            public String getPath() {
                return string;
            }

            @Override
            public int getStartOffset() {
                return DeletionVectorStoredBitmap.this.dvDescriptor.getOffset().orElse(0);
            }

            @Override
            public int getReadLength() {
                return DeletionVectorStoredBitmap.this.dvDescriptor.getSizeInBytes() + 8;
            }
        };
        CloseableIterator<ByteArrayInputStream> closeableIterator = fileSystemClient.readFiles(Utils.singletonCloseableIterator(fileReadRequest));
        ByteArrayInputStream byteArrayInputStream = InternalUtils.getSingularElement(closeableIterator).orElseThrow(() -> new IllegalStateException("Iterator should not be empty"));
        return this.loadFromStream(byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoaringBitmapArray loadFromStream(ByteArrayInputStream byteArrayInputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (this.dvDescriptor.getSizeInBytes() != n) {
                throw new RuntimeException("DV size mismatch");
            }
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            int n2 = dataInputStream.readInt();
            int n3 = this.calculateChecksum(byArray);
            if (n2 != n3) {
                throw new RuntimeException("DV checksum mismatch");
            }
            RoaringBitmapArray roaringBitmapArray = RoaringBitmapArray.readFrom(byArray);
            return roaringBitmapArray;
        }
        finally {
            byteArrayInputStream.close();
            dataInputStream.close();
        }
    }

    private int calculateChecksum(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return (int)cRC32.getValue();
    }
}

