/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.client.FileReadContext;
import io.delta.kernel.client.JsonHandler;
import io.delta.kernel.client.ParquetHandler;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.FileDataReadResult;
import io.delta.kernel.expressions.AlwaysTrue;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

class ActionsIterator
implements CloseableIterator<Tuple2<FileDataReadResult, Boolean>> {
    private final TableClient tableClient;
    private final Iterator<FileStatus> filesIter;
    private final StructType readSchema;
    private Optional<CloseableIterator<Tuple2<FileDataReadResult, Boolean>>> actionsIter;
    private boolean closed;

    ActionsIterator(TableClient tableClient, List<FileStatus> list, StructType structType) {
        this.tableClient = tableClient;
        this.filesIter = list.iterator();
        this.readSchema = structType;
        this.actionsIter = Optional.empty();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `hasNext` on a closed iterator.");
        }
        this.tryEnsureNextActionsIterIsReady();
        return this.actionsIter.isPresent();
    }

    @Override
    public Tuple2<FileDataReadResult, Boolean> next() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `next` on a closed iterator.");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        return (Tuple2)this.actionsIter.get().next();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed && this.actionsIter.isPresent()) {
            this.actionsIter.get().close();
            this.actionsIter = Optional.empty();
            this.closed = true;
        }
    }

    private void tryEnsureNextActionsIterIsReady() {
        if (this.actionsIter.isPresent()) {
            if (this.actionsIter.get().hasNext()) {
                return;
            }
            Utils.closeCloseables(this.actionsIter.get());
            this.actionsIter = Optional.empty();
        }
        while (this.filesIter.hasNext()) {
            this.actionsIter = Optional.of(this.getNextActionsIter());
            if (this.actionsIter.get().hasNext()) {
                return;
            }
            Utils.closeCloseables(this.actionsIter.get());
            this.actionsIter = Optional.empty();
        }
    }

    private CloseableIterator<Tuple2<FileDataReadResult, Boolean>> getNextActionsIter() {
        FileStatus fileStatus = this.filesIter.next();
        AutoCloseable[] autoCloseableArray = new Closeable[2];
        try {
            if (fileStatus.getPath().endsWith(".json")) {
                CloseableIterator<FileDataReadResult> closeableIterator;
                CloseableIterator<FileReadContext> closeableIterator2;
                JsonHandler jsonHandler = this.tableClient.getJsonHandler();
                autoCloseableArray[0] = closeableIterator2 = jsonHandler.contextualizeFileReads(Utils.singletonCloseableIterator(InternalScanFileUtils.generateScanFileRow(fileStatus)), AlwaysTrue.ALWAYS_TRUE);
                autoCloseableArray[1] = closeableIterator = this.tableClient.getJsonHandler().readJsonFiles(closeableIterator2, this.readSchema);
                return this.combine(closeableIterator, false);
            }
            if (fileStatus.getPath().endsWith(".parquet")) {
                CloseableIterator<FileDataReadResult> closeableIterator;
                CloseableIterator<FileReadContext> closeableIterator3;
                ParquetHandler parquetHandler = this.tableClient.getParquetHandler();
                autoCloseableArray[0] = closeableIterator3 = parquetHandler.contextualizeFileReads(Utils.singletonCloseableIterator(InternalScanFileUtils.generateScanFileRow(fileStatus)), AlwaysTrue.ALWAYS_TRUE);
                autoCloseableArray[1] = closeableIterator = this.tableClient.getParquetHandler().readParquetFiles(closeableIterator3, this.readSchema);
                return this.combine(closeableIterator, true);
            }
            throw new IllegalStateException(String.format("Unexpected log file path: %s", fileStatus.getPath()));
        }
        catch (IOException iOException) {
            Utils.closeCloseablesSilently(autoCloseableArray);
            throw new UncheckedIOException(iOException);
        }
    }

    private CloseableIterator<Tuple2<FileDataReadResult, Boolean>> combine(final CloseableIterator<FileDataReadResult> closeableIterator, final boolean bl) {
        return new CloseableIterator<Tuple2<FileDataReadResult, Boolean>>(){

            @Override
            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            @Override
            public Tuple2<FileDataReadResult, Boolean> next() {
                return new Tuple2<FileDataReadResult, Boolean>((FileDataReadResult)closeableIterator.next(), bl);
            }

            @Override
            public void close() throws IOException {
                closeableIterator.close();
            }
        };
    }
}

