/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FileDataReadResult;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.expressions.ExpressionEvaluator;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.StringType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

class ActiveAddFilesIterator
implements CloseableIterator<FilteredColumnarBatch> {
    private final TableClient tableClient;
    private final Path tableRoot;
    private final CloseableIterator<Tuple2<FileDataReadResult, Boolean>> iter;
    private final Set<UniqueFileActionTuple> tombstonesFromJson;
    private final Set<UniqueFileActionTuple> addFilesFromJson;
    private Optional<FilteredColumnarBatch> next;
    private boolean[] selectionVectorBuffer;
    private ExpressionEvaluator tableRootVectorGenerator;
    private boolean closed;

    ActiveAddFilesIterator(TableClient tableClient, CloseableIterator<Tuple2<FileDataReadResult, Boolean>> closeableIterator, Path path) {
        this.tableClient = tableClient;
        this.tableRoot = path;
        this.iter = closeableIterator;
        this.tombstonesFromJson = new HashSet<UniqueFileActionTuple>();
        this.addFilesFromJson = new HashSet<UniqueFileActionTuple>();
        this.next = Optional.empty();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `hasNext` on a closed iterator.");
        }
        if (!this.next.isPresent()) {
            this.prepareNext();
        }
        return this.next.isPresent();
    }

    @Override
    public FilteredColumnarBatch next() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `next` on a closed iterator.");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        FilteredColumnarBatch filteredColumnarBatch = this.next.get();
        this.next = Optional.empty();
        return filteredColumnarBatch;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.iter.close();
            this.closed = true;
        }
    }

    private void prepareNext() {
        Object object;
        Optional<ColumnVector> optional;
        Object object2;
        int n;
        ColumnVector columnVector;
        if (this.next.isPresent()) {
            return;
        }
        if (!this.iter.hasNext()) {
            return;
        }
        Tuple2 tuple2 = (Tuple2)this.iter.next();
        FileDataReadResult fileDataReadResult = (FileDataReadResult)tuple2._1;
        boolean bl = (Boolean)tuple2._2;
        ColumnarBatch columnarBatch = fileDataReadResult.getData();
        assert (columnarBatch.getSchema().equals(LogReplay.ADD_REMOVE_READ_SCHEMA));
        if (!bl) {
            columnVector = columnarBatch.getColumnVector(LogReplay.REMOVE_FILE_ORDINAL);
            for (n = 0; n < columnVector.getSize(); ++n) {
                if (columnVector.isNullAt(n)) continue;
                String string = ActiveAddFilesIterator.getRemoveFilePath(columnVector, n);
                object2 = this.pathToUri(string);
                optional = Optional.ofNullable(ActiveAddFilesIterator.getRemoveFileDV(columnVector, n)).map(DeletionVectorDescriptor::getUniqueId);
                object = new UniqueFileActionTuple((URI)object2, (Optional<String>)optional);
                this.tombstonesFromJson.add((UniqueFileActionTuple)object);
            }
        }
        columnVector = columnarBatch.getColumnVector(LogReplay.ADD_FILE_ORDINAL);
        this.prepareSelectionVectorBuffer(columnVector.getSize());
        n = 0;
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) {
                n = 1;
                continue;
            }
            object2 = ActiveAddFilesIterator.getAddFilePath(columnVector, i);
            optional = this.pathToUri((String)object2);
            object = Optional.ofNullable(ActiveAddFilesIterator.getAddFileDV(columnVector, i)).map(DeletionVectorDescriptor::getUniqueId);
            UniqueFileActionTuple uniqueFileActionTuple = new UniqueFileActionTuple((URI)((Object)optional), (Optional<String>)object);
            boolean bl2 = this.tombstonesFromJson.contains(uniqueFileActionTuple);
            boolean bl3 = this.addFilesFromJson.contains(uniqueFileActionTuple);
            boolean bl4 = false;
            if (!bl3) {
                if (!bl) {
                    this.addFilesFromJson.add(uniqueFileActionTuple);
                }
                if (!bl2) {
                    bl4 = true;
                    this.selectionVectorBuffer[i] = true;
                }
            }
            if (bl4) continue;
            n = 1;
        }
        ColumnarBatch columnarBatch2 = columnarBatch.withDeletedColumnAt(1);
        if (this.tableRootVectorGenerator == null) {
            this.tableRootVectorGenerator = this.tableClient.getExpressionHandler().getEvaluator(columnarBatch2.getSchema(), Literal.ofString(this.tableRoot.toUri().toString()), StringType.STRING);
        }
        object2 = this.tableRootVectorGenerator.eval(columnarBatch2);
        columnarBatch2 = columnarBatch2.withNewColumn(1, InternalScanFileUtils.TABLE_ROOT_STRUCT_FIELD, (ColumnVector)object2);
        optional = n != 0 ? Optional.of(this.tableClient.getExpressionHandler().createSelectionVector(this.selectionVectorBuffer, 0, columnVector.getSize())) : Optional.empty();
        this.next = Optional.of(new FilteredColumnarBatch(columnarBatch2, optional));
    }

    private void prepareSelectionVectorBuffer(int n) {
        if (this.selectionVectorBuffer == null || this.selectionVectorBuffer.length < n) {
            this.selectionVectorBuffer = new boolean[n];
        } else {
            Arrays.fill(this.selectionVectorBuffer, false);
        }
    }

    private URI pathToUri(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    public static String getAddFilePath(ColumnVector columnVector, int n) {
        return columnVector.getChild(LogReplay.ADD_FILE_PATH_ORDINAL).getString(n);
    }

    public static DeletionVectorDescriptor getAddFileDV(ColumnVector columnVector, int n) {
        return DeletionVectorDescriptor.fromColumnVector(columnVector.getChild(LogReplay.ADD_FILE_DV_ORDINAL), n);
    }

    public static String getRemoveFilePath(ColumnVector columnVector, int n) {
        return columnVector.getChild(LogReplay.REMOVE_FILE_PATH_ORDINAL).getString(n);
    }

    public static DeletionVectorDescriptor getRemoveFileDV(ColumnVector columnVector, int n) {
        return DeletionVectorDescriptor.fromColumnVector(columnVector.getChild(LogReplay.REMOVE_FILE_DV_ORDINAL), n);
    }

    private static class UniqueFileActionTuple
    extends Tuple2<URI, Optional<String>> {
        UniqueFileActionTuple(URI uRI, Optional<String> optional) {
            super(uRI, optional);
        }
    }
}

