/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FileDataReadResult;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.internal.replay.ActionsIterator;
import io.delta.kernel.internal.replay.ActiveAddFilesIterator;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.util.Logging;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class LogReplay
implements Logging {
    public static final StructType PROTOCOL_METADATA_READ_SCHEMA = new StructType().add("protocol", Protocol.READ_SCHEMA).add("metaData", Metadata.READ_SCHEMA);
    public static final StructType ADD_REMOVE_READ_SCHEMA = new StructType().add("add", AddFile.SCHEMA).add("remove", new StructType().add("path", (DataType)StringType.STRING, false).add("deletionVector", (DataType)DeletionVectorDescriptor.READ_SCHEMA, true));
    public static int ADD_FILE_ORDINAL = ADD_REMOVE_READ_SCHEMA.indexOf("add");
    public static int ADD_FILE_PATH_ORDINAL = ((StructType)ADD_REMOVE_READ_SCHEMA.get("add").getDataType()).indexOf("path");
    public static int ADD_FILE_DV_ORDINAL = ((StructType)ADD_REMOVE_READ_SCHEMA.get("add").getDataType()).indexOf("deletionVector");
    public static int REMOVE_FILE_ORDINAL = ADD_REMOVE_READ_SCHEMA.indexOf("remove");
    public static int REMOVE_FILE_PATH_ORDINAL = ((StructType)ADD_REMOVE_READ_SCHEMA.get("remove").getDataType()).indexOf("path");
    public static int REMOVE_FILE_DV_ORDINAL = ((StructType)ADD_REMOVE_READ_SCHEMA.get("remove").getDataType()).indexOf("deletionVector");
    public static final StructType ADD_ONLY_DATA_SCHEMA = new StructType().add("add", AddFile.SCHEMA);
    private final Path dataPath;
    private final LogSegment logSegment;
    private final TableClient tableClient;
    private final Lazy<Tuple2<Protocol, Metadata>> protocolAndMetadata;

    public LogReplay(Path path, Path path2, TableClient tableClient, LogSegment logSegment) {
        LogReplay.assertLogFilesBelongToTable(path, logSegment.allLogFilesUnsorted());
        this.dataPath = path2;
        this.logSegment = logSegment;
        this.tableClient = tableClient;
        this.protocolAndMetadata = new Lazy<Tuple2>(this::loadTableProtocolAndMetadata);
    }

    public Tuple2<Protocol, Metadata> loadProtocolAndMetadata() {
        return this.protocolAndMetadata.get();
    }

    public CloseableIterator<FilteredColumnarBatch> getAddFilesAsColumnarBatches() {
        ActionsIterator actionsIterator = new ActionsIterator(this.tableClient, this.logSegment.allLogFilesReversed(), ADD_REMOVE_READ_SCHEMA);
        return new ActiveAddFilesIterator(this.tableClient, actionsIterator, this.dataPath);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Tuple2<Protocol, Metadata> loadTableProtocolAndMetadata() {
        Protocol protocol = null;
        Metadata metadata = null;
        try (ActionsIterator actionsIterator = new ActionsIterator(this.tableClient, this.logSegment.allLogFilesReversed(), PROTOCOL_METADATA_READ_SCHEMA);){
            block17: while (actionsIterator.hasNext()) {
                int n;
                ColumnVector columnVector;
                ColumnarBatch columnarBatch = ((FileDataReadResult)((Tuple2)actionsIterator.next())._1).getData();
                assert (columnarBatch.getSchema().equals(PROTOCOL_METADATA_READ_SCHEMA));
                if (protocol == null) {
                    columnVector = columnarBatch.getColumnVector(0);
                    for (n = 0; n < columnVector.getSize(); ++n) {
                        if (columnVector.isNullAt(n)) continue;
                        protocol = Protocol.fromColumnVector(columnVector, n);
                        if (metadata == null) break;
                        this.validateSupportedTable(protocol, metadata);
                        Tuple2<Protocol, Metadata> tuple2 = new Tuple2<Protocol, Metadata>(protocol, metadata);
                        return tuple2;
                    }
                }
                if (metadata != null) continue;
                columnVector = columnarBatch.getColumnVector(1);
                for (n = 0; n < columnVector.getSize(); ++n) {
                    if (columnVector.isNullAt(n)) continue;
                    metadata = Metadata.fromColumnVector(columnVector, n, this.tableClient);
                    if (protocol == null) continue block17;
                    this.validateSupportedTable(protocol, metadata);
                    Tuple2<Protocol, Metadata> tuple2 = new Tuple2<Protocol, Metadata>(protocol, metadata);
                    return tuple2;
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not close iterator", iOException);
        }
        if (protocol == null) {
            throw new IllegalStateException(String.format("No protocol found at version %s", this.logSegment.version));
        }
        throw new IllegalStateException(String.format("No metadata found at version %s", this.logSegment.version));
    }

    private void validateSupportedTable(Protocol protocol, Metadata metadata) {
        switch (protocol.getMinReaderVersion()) {
            case 1: {
                break;
            }
            case 2: {
                this.verifySupportedColumnMappingMode(metadata);
                break;
            }
            case 3: {
                List<String> list = protocol.getReaderFeatures();
                Iterator<String> iterator = list.iterator();
                block13: while (iterator.hasNext()) {
                    String string;
                    switch (string = iterator.next()) {
                        case "deletionVectors": {
                            continue block13;
                        }
                        case "columnMapping": {
                            this.verifySupportedColumnMappingMode(metadata);
                            continue block13;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported table feature: " + string);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported protocol version: " + protocol.getMinReaderVersion());
            }
        }
    }

    private void verifySupportedColumnMappingMode(Metadata metadata) {
        String string = metadata.getConfiguration().getOrDefault("delta.columnMapping.mode", "none");
        if (!"none".equalsIgnoreCase(string) && !"name".equalsIgnoreCase(string)) {
            throw new UnsupportedOperationException("Unsupported column mapping mode: " + string);
        }
    }

    private static void assertLogFilesBelongToTable(Path path, List<FileStatus> list) {
    }
}

