/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.types;

import io.delta.kernel.client.JsonHandler;
import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.types.MixedDataType;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BasePrimitiveType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableSchemaSerDe {
    private static final StructType STRUCT_FIELD_SCHEMA = new StructType().add("name", StringType.STRING).add("type", MixedDataType.INSTANCE).add("nullable", BooleanType.BOOLEAN).add("metadata", new MapType(StringType.STRING, StringType.STRING, false));
    private static StructType STRUCT_TYPE_SCHEMA = new StructType().add("fields", new ArrayType(STRUCT_FIELD_SCHEMA, false));
    private static StructType ARRAY_TYPE_SCHEMA = new StructType().add("type", StringType.STRING).add("elementType", MixedDataType.INSTANCE).add("containsNull", BooleanType.BOOLEAN);
    private static StructType MAP_TYPE_SCHEMA = new StructType().add("type", StringType.STRING).add("keyType", MixedDataType.INSTANCE).add("valueType", MixedDataType.INSTANCE).add("valueContainsNull", BooleanType.BOOLEAN);
    private static Pattern DECIMAL_TYPE_PATTERN = Pattern.compile("decimal\\(\\s*(?<precision>[0-9]+),\\s*(?<scale>[0-9]+)\\s*\\)");

    private TableSchemaSerDe() {
    }

    public static String toJson(StructType structType) {
        return structType.toJson();
    }

    public static StructType fromJson(JsonHandler jsonHandler, String string) {
        return TableSchemaSerDe.parseStructType(jsonHandler, string);
    }

    private static StructType parseStructType(JsonHandler jsonHandler, String string) {
        Function<Row, StructType> function = row -> {
            ArrayValue arrayValue = row.getArray(0);
            ArrayList<StructField> arrayList = new ArrayList<StructField>(arrayValue.getSize());
            for (int i = 0; i < arrayValue.getSize(); ++i) {
                arrayList.add(TableSchemaSerDe.parseStructField(jsonHandler, arrayValue.getElements(), i));
            }
            return new StructType(arrayList);
        };
        return TableSchemaSerDe.parseAndEvalSingleRow(jsonHandler, string, STRUCT_TYPE_SCHEMA, function);
    }

    private static StructField parseStructField(JsonHandler jsonHandler, ColumnVector columnVector, int n) {
        String string = columnVector.getChild(0).getString(n);
        String string2 = columnVector.getChild(1).getString(n);
        DataType dataType = TableSchemaSerDe.parseDataType(jsonHandler, string2);
        boolean bl = columnVector.getChild(2).getBoolean(n);
        Map<String, String> map = columnVector.getChild(3).isNullAt(n) ? Collections.emptyMap() : VectorUtils.toJavaMap(columnVector.getChild(3).getMap(n));
        return new StructField(string, dataType, bl, map);
    }

    private static DataType parseDataType(JsonHandler jsonHandler, String string) {
        if (BasePrimitiveType.isPrimitiveType(string)) {
            return BasePrimitiveType.createPrimitive(string);
        }
        if (string.startsWith("decimal")) {
            if (string.equalsIgnoreCase("decimal")) {
                return DecimalType.USER_DEFAULT;
            }
            Matcher matcher = DECIMAL_TYPE_PATTERN.matcher(string);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid decimal type format: " + string);
            }
            return new DecimalType(Integer.valueOf(matcher.group("precision")), Integer.valueOf(matcher.group("scale")));
        }
        Optional<ArrayType> optional = TableSchemaSerDe.parseAsArrayType(jsonHandler, string);
        if (optional.isPresent()) {
            return optional.get();
        }
        Optional<MapType> optional2 = TableSchemaSerDe.parseAsMapType(jsonHandler, string);
        if (optional2.isPresent()) {
            return optional2.get();
        }
        return TableSchemaSerDe.parseStructType(jsonHandler, string);
    }

    private static Optional<ArrayType> parseAsArrayType(JsonHandler jsonHandler, String string) {
        Function<Row, Optional> function = row -> {
            if (!"array".equalsIgnoreCase(row.getString(0))) {
                return Optional.empty();
            }
            if (row.isNullAt(1) || row.isNullAt(2)) {
                throw new IllegalArgumentException("invalid array serialized format: " + string);
            }
            DataType dataType = TableSchemaSerDe.parseDataType(jsonHandler, row.getString(1));
            boolean bl = row.getBoolean(2);
            return Optional.of(new ArrayType(dataType, bl));
        };
        return TableSchemaSerDe.parseAndEvalSingleRow(jsonHandler, string, ARRAY_TYPE_SCHEMA, function);
    }

    private static Optional<MapType> parseAsMapType(JsonHandler jsonHandler, String string) {
        Function<Row, Optional> function = row -> {
            if (!"map".equalsIgnoreCase(row.getString(0))) {
                return Optional.empty();
            }
            if (row.isNullAt(1) || row.isNullAt(2) || row.isNullAt(3)) {
                throw new IllegalArgumentException("invalid map serialized format: " + string);
            }
            DataType dataType = TableSchemaSerDe.parseDataType(jsonHandler, row.getString(1));
            DataType dataType2 = TableSchemaSerDe.parseDataType(jsonHandler, row.getString(2));
            boolean bl = row.getBoolean(3);
            return Optional.of(new MapType(dataType, dataType2, bl));
        };
        return TableSchemaSerDe.parseAndEvalSingleRow(jsonHandler, string, MAP_TYPE_SCHEMA, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R> R parseAndEvalSingleRow(JsonHandler jsonHandler, String string, StructType structType, Function<Row, R> function) {
        R r;
        ColumnVector columnVector = InternalUtils.singletonStringColumnVector(string);
        ColumnarBatch columnarBatch = jsonHandler.parseJson(columnVector, structType);
        assert (columnarBatch.getSize() == 1);
        CloseableIterator<Row> closeableIterator = columnarBatch.getRows();
        try {
            r = function.apply((Row)closeableIterator.next());
        }
        catch (Throwable throwable) {
            Utils.closeCloseables(closeableIterator);
            throw throwable;
        }
        Utils.closeCloseables(closeableIterator);
        return r;
    }
}

