/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.internal.fs.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class FileNames {
    private static final Pattern DELTA_FILE_PATTERN = Pattern.compile("\\d+\\.json");
    private static final Pattern CHECKPOINT_FILE_PATTERN = Pattern.compile("\\d+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet");

    private FileNames() {
    }

    public static String deltaFile(Path path, long l) {
        return String.format("%s/%020d.json", path, l);
    }

    public static long deltaVersion(Path path) {
        return Long.parseLong(path.getName().split("\\.")[0]);
    }

    public static long checkpointVersion(Path path) {
        return Long.parseLong(path.getName().split("\\.")[0]);
    }

    public static String listingPrefix(Path path, long l) {
        return String.format("%s/%020d.", path, l);
    }

    public static Path checkpointFileSingular(Path path, long l) {
        return new Path(path, String.format("%020d.checkpoint.parquet", l));
    }

    public static List<Path> checkpointFileWithParts(Path path, long l, int n) {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (int i = 1; i < n + 1; ++i) {
            arrayList.add(new Path(path, String.format("%020d.checkpoint.%010d.%010d.parquet", l, i, n)));
        }
        return arrayList;
    }

    public static boolean isCheckpointFile(String string) {
        return CHECKPOINT_FILE_PATTERN.matcher(string).find();
    }

    public static boolean isCommitFile(String string) {
        return DELTA_FILE_PATTERN.matcher(string).find();
    }

    public static long getFileVersion(Path path) {
        if (FileNames.isCheckpointFile(path.getName())) {
            return FileNames.checkpointVersion(path);
        }
        if (FileNames.isCommitFile(path.getName())) {
            return FileNames.deltaVersion(path);
        }
        throw new IllegalArgumentException(String.format("Unexpected file type found in transaction log: %s", path));
    }
}

