/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.client.ExpressionHandler;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.expressions.AlwaysFalse;
import io.delta.kernel.expressions.AlwaysTrue;
import io.delta.kernel.expressions.And;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.ExpressionEvaluator;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.PartitionValueExpression;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.expressions.ScalarExpression;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PartitionUtils {
    private PartitionUtils() {
    }

    public static StructType physicalSchemaWithoutPartitionColumns(final StructType structType, final StructType structType2, Set<String> set) {
        if (set == null || set.size() == 0) {
            return structType2;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(){
            {
                IntStream.range(0, structType.length()).mapToObj(n -> new Tuple2<StructField, StructField>(structType.at(n), structType2.at(n))).forEach((? super T tuple2) -> this.put(((StructField)tuple2._2).getName(), ((StructField)tuple2._1).getName()));
            }
        };
        return new StructType(structType2.fields().stream().filter(structField -> !set.contains(hashMap.get(structField.getName()))).collect(Collectors.toList()));
    }

    public static ColumnarBatch withPartitionColumns(ExpressionHandler expressionHandler, ColumnarBatch columnarBatch, StructType structType, Map<String, String> map, StructType structType2) {
        if (map == null || map.size() == 0) {
            return columnarBatch;
        }
        for (int i = 0; i < structType2.length(); ++i) {
            StructField structField = structType2.at(i);
            if (!map.containsKey(structField.getName())) continue;
            ExpressionEvaluator expressionEvaluator = expressionHandler.getEvaluator(structType, PartitionUtils.literalForPartitionValue(structField.getDataType(), map.get(structField.getName())), structField.getDataType());
            ColumnVector columnVector = expressionEvaluator.eval(columnarBatch);
            columnarBatch = columnarBatch.withNewColumn(i, structField, columnVector);
        }
        return columnarBatch;
    }

    public static Tuple2<Predicate, Predicate> splitMetadataAndDataPredicates(Predicate predicate, Set<String> set) {
        String string = predicate.getName();
        List<Expression> list = predicate.getChildren();
        if ("AND".equalsIgnoreCase(string)) {
            Predicate predicate2 = (Predicate)list.get(0);
            Predicate predicate3 = (Predicate)list.get(1);
            Tuple2<Predicate, Predicate> tuple2 = PartitionUtils.splitMetadataAndDataPredicates(predicate2, set);
            Tuple2<Predicate, Predicate> tuple22 = PartitionUtils.splitMetadataAndDataPredicates(predicate3, set);
            return new Tuple2<Predicate, Predicate>(PartitionUtils.combineWithAndOp((Predicate)tuple2._1, (Predicate)tuple22._1), PartitionUtils.combineWithAndOp((Predicate)tuple2._2, (Predicate)tuple22._2));
        }
        if (PartitionUtils.hasNonPartitionColumns(list, set)) {
            return new Tuple2<Predicate, Predicate>(AlwaysTrue.ALWAYS_TRUE, predicate);
        }
        return new Tuple2<Predicate, Predicate>(predicate, AlwaysTrue.ALWAYS_TRUE);
    }

    public static Predicate rewritePartitionPredicateOnScanFileSchema(Predicate predicate, Map<String, DataType> map) {
        return new Predicate(predicate.getName(), predicate.getChildren().stream().map(expression -> PartitionUtils.rewritePartitionColumnRef(expression, map)).collect(Collectors.toList()));
    }

    private static Expression rewritePartitionColumnRef(Expression expression, Map<String, DataType> map) {
        Column column = InternalScanFileUtils.ADD_FILE_PARTITION_COL_REF;
        if (expression instanceof Column) {
            Column column2 = (Column)expression;
            String string = column2.getNames()[0];
            DataType dataType = map.get(string.toLowerCase(Locale.ROOT));
            if (dataType == null) {
                throw new IllegalArgumentException(string + " has no data type in metadata");
            }
            ScalarExpression scalarExpression = new ScalarExpression("element_at", Arrays.asList(column, Literal.ofString(string)));
            if (dataType instanceof StringType) {
                return scalarExpression;
            }
            return new PartitionValueExpression(scalarExpression, dataType);
        }
        if (expression instanceof Predicate) {
            return PartitionUtils.rewritePartitionPredicateOnScanFileSchema((Predicate)expression, map);
        }
        return expression;
    }

    private static boolean hasNonPartitionColumns(List<Expression> list, Set<String> set) {
        for (Expression expression : list) {
            if (expression instanceof Column) {
                String[] stringArray = ((Column)expression).getNames();
                if (stringArray.length == 1 && set.contains(stringArray[0])) continue;
                return true;
            }
            return PartitionUtils.hasNonPartitionColumns(expression.getChildren(), set);
        }
        return false;
    }

    private static Predicate combineWithAndOp(Predicate predicate, Predicate predicate2) {
        String string = predicate.getName().toUpperCase();
        String string2 = predicate2.getName().toUpperCase();
        if (string.equals("ALWAYS_FALSE") || string2.equals("ALWAYS_FALSE")) {
            return AlwaysFalse.ALWAYS_FALSE;
        }
        if (string.equals("ALWAYS_TRUE")) {
            return predicate2;
        }
        if (string2.equals("ALWAYS_TRUE")) {
            return predicate;
        }
        return new And(predicate, predicate2);
    }

    private static Literal literalForPartitionValue(DataType dataType, String string) {
        if (string == null) {
            return Literal.ofNull(dataType);
        }
        if (dataType instanceof BooleanType) {
            return Literal.ofBoolean(Boolean.parseBoolean(string));
        }
        if (dataType instanceof ByteType) {
            return Literal.ofByte(Byte.parseByte(string));
        }
        if (dataType instanceof ShortType) {
            return Literal.ofShort(Short.parseShort(string));
        }
        if (dataType instanceof IntegerType) {
            return Literal.ofInt(Integer.parseInt(string));
        }
        if (dataType instanceof LongType) {
            return Literal.ofLong(Long.parseLong(string));
        }
        if (dataType instanceof FloatType) {
            return Literal.ofFloat(Float.parseFloat(string));
        }
        if (dataType instanceof DoubleType) {
            return Literal.ofDouble(Double.parseDouble(string));
        }
        if (dataType instanceof StringType) {
            return Literal.ofString(string);
        }
        if (dataType instanceof BinaryType) {
            return Literal.ofBinary(string.getBytes());
        }
        if (dataType instanceof DateType) {
            return Literal.ofDate(InternalUtils.daysSinceEpoch(Date.valueOf(string)));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return Literal.ofDecimal(new BigDecimal(string), decimalType.getPrecision(), decimalType.getScale());
        }
        throw new UnsupportedOperationException("Unsupported partition column: " + dataType);
    }
}

