/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel;

import io.delta.kernel.client.FileReadContext;
import io.delta.kernel.client.ParquetHandler;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.DataReadResult;
import io.delta.kernel.data.FileDataReadResult;
import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.data.AddFileColumnarBatch;
import io.delta.kernel.internal.data.ScanStateRow;
import io.delta.kernel.internal.data.SelectionColumnVector;
import io.delta.kernel.internal.deletionvectors.DeletionVectorUtils;
import io.delta.kernel.internal.deletionvectors.RoaringBitmapArray;
import io.delta.kernel.internal.util.PartitionUtils;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.Tuple2;
import io.delta.kernel.utils.Utils;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public interface Scan {
    public CloseableIterator<ColumnarBatch> getScanFiles(TableClient var1);

    public Optional<Expression> getRemainingFilter();

    public Row getScanState(TableClient var1);

    public static CloseableIterator<DataReadResult> readData(final TableClient tableClient, final Row row, CloseableIterator<Row> closeableIterator, Optional<Expression> optional) throws IOException {
        final StructType structType = Utils.getPhysicalSchema(tableClient, row);
        final StructType structType2 = Utils.getLogicalSchema(tableClient, row);
        List<String> list = Utils.getPartitionColumns(row);
        HashSet<String> hashSet = new HashSet<String>(list);
        final StructType structType3 = PartitionUtils.physicalSchemaWithoutPartitionColumns(structType2, structType, hashSet);
        StructType structType4 = structType3.add(StructField.ROW_INDEX_COLUMN);
        ParquetHandler parquetHandler = tableClient.getParquetHandler();
        CloseableIterator<FileReadContext> closeableIterator2 = parquetHandler.contextualizeFileReads(closeableIterator, optional.orElse(Literal.TRUE));
        final CloseableIterator<FileDataReadResult> closeableIterator3 = parquetHandler.readParquetFiles(closeableIterator2, structType4);
        final String string = ScanStateRow.getTablePath(row);
        return new CloseableIterator<DataReadResult>(){
            RoaringBitmapArray currBitmap = null;
            DeletionVectorDescriptor currDV = null;

            @Override
            public void close() throws IOException {
                closeableIterator3.close();
            }

            @Override
            public boolean hasNext() {
                return closeableIterator3.hasNext();
            }

            @Override
            public DataReadResult next() {
                String string2;
                Object object;
                Optional<ColumnVector> optional;
                FileDataReadResult fileDataReadResult = (FileDataReadResult)closeableIterator3.next();
                Row row2 = fileDataReadResult.getScanFileRow();
                DeletionVectorDescriptor deletionVectorDescriptor = DeletionVectorDescriptor.fromRow(row2.getStruct(AddFileColumnarBatch.getDeletionVectorColOrdinal()));
                int n = fileDataReadResult.getData().getSchema().indexOf(StructField.ROW_INDEX_COLUMN_NAME);
                if (deletionVectorDescriptor == null) {
                    optional = Optional.empty();
                } else {
                    if (!deletionVectorDescriptor.equals(this.currDV)) {
                        object = DeletionVectorUtils.loadNewDvAndBitmap(tableClient, string, deletionVectorDescriptor);
                        this.currDV = (DeletionVectorDescriptor)((Tuple2)object)._1;
                        this.currBitmap = (RoaringBitmapArray)((Tuple2)object)._2;
                    }
                    object = fileDataReadResult.getData().getColumnVector(n);
                    optional = Optional.of(new SelectionColumnVector(this.currBitmap, (ColumnVector)object));
                }
                object = fileDataReadResult.getData().withDeletedColumnAt(n);
                object = PartitionUtils.withPartitionColumns(tableClient.getExpressionHandler(), object, structType3, Utils.getPartitionValues(fileDataReadResult.getScanFileRow()), structType);
                switch (string2 = Utils.getColumnMappingMode(row)) {
                    case "name": {
                        object = object.withNewSchema(structType2);
                        break;
                    }
                    case "none": {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Column mapping mode is not yet supported: " + string2);
                    }
                }
                return new DataReadResult((ColumnarBatch)object, optional);
            }
        };
    }
}

