/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.expressions;

import io.delta.kernel.expressions.BinaryOperator;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.types.BooleanType;
import java.util.Collection;

public final class And
extends BinaryOperator
implements Predicate {
    public static And apply(Collection<Expression> collection) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException("And.apply must be called with at least 1 element");
        }
        return (And)collection.stream().reduce(new And(Literal.TRUE, Literal.TRUE), And::new);
    }

    public And(Expression expression, Expression expression2) {
        super(expression, expression2, "&&");
        if (!(expression.dataType() instanceof BooleanType) || !(expression2.dataType() instanceof BooleanType)) {
            throw new IllegalArgumentException(String.format("'And' requires expressions of type boolean. Got %s and %s.", expression.dataType(), expression2.dataType()));
        }
    }

    @Override
    public Object nullSafeEval(Object object, Object object2) {
        return (Boolean)object != false && (Boolean)object2 != false;
    }
}

