/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.expressions;

import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.Expression;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class BinaryExpression
implements Expression {
    protected final Expression left;
    protected final Expression right;

    protected BinaryExpression(Expression expression, Expression expression2) {
        this.left = expression;
        this.right = expression2;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public final Object eval(Row row) {
        Object object = this.left.eval(row);
        if (null == object) {
            return null;
        }
        Object object2 = this.right.eval(row);
        if (null == object2) {
            return null;
        }
        return this.nullSafeEval(object, object2);
    }

    protected abstract Object nullSafeEval(Object var1, Object var2);

    @Override
    public List<Expression> children() {
        return Arrays.asList(this.left, this.right);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BinaryExpression binaryExpression = (BinaryExpression)object;
        return Objects.equals(this.left, binaryExpression.left) && Objects.equals(this.right, binaryExpression.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

