/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.expressions;

import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.LeafExpression;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.StringType;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public final class Column
extends LeafExpression {
    private final int ordinal;
    private final String name;
    private final DataType dataType;
    private final RowEvaluator evaluator;

    public Column(int n, String string, DataType dataType) {
        this.ordinal = n;
        this.name = string;
        this.dataType = dataType;
        if (dataType instanceof IntegerType) {
            this.evaluator = row -> row.getInt(n);
        } else if (dataType instanceof BooleanType) {
            this.evaluator = row -> row.getBoolean(n);
        } else if (dataType instanceof LongType) {
            this.evaluator = row -> row.getLong(n);
        } else if (dataType instanceof StringType) {
            this.evaluator = row -> row.getString(n);
        } else {
            throw new UnsupportedOperationException(String.format("The data type %s of column %s at ordinal %s is not supported", dataType, string, n));
        }
    }

    public String name() {
        return this.name;
    }

    @Override
    public Object eval(Row row) {
        return row.isNullAt(this.ordinal) ? null : this.evaluator.nullSafeEval(row);
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public String toString() {
        return "Column(" + this.name + ")";
    }

    @Override
    public Set<String> references() {
        return Collections.singleton(this.name);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Column column = (Column)object;
        return Objects.equals(this.ordinal, column.ordinal) && Objects.equals(this.name, column.name) && Objects.equals(this.dataType, column.dataType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.dataType);
    }

    @FunctionalInterface
    private static interface RowEvaluator {
        public Object nullSafeEval(Row var1);
    }
}

