/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.expressions;

import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.LeafExpression;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampType;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Objects;

public final class Literal
extends LeafExpression {
    public static final Literal TRUE = Literal.of(true);
    public static final Literal FALSE = Literal.of(false);
    private final Object value;
    private final DataType dataType;

    public static Literal of(boolean bl) {
        return new Literal(bl, BooleanType.INSTANCE);
    }

    public static Literal of(byte by) {
        return new Literal(by, ByteType.INSTANCE);
    }

    public static Literal of(short s) {
        return new Literal(s, ShortType.INSTANCE);
    }

    public static Literal of(int n) {
        return new Literal(n, IntegerType.INSTANCE);
    }

    public static Literal of(long l) {
        return new Literal(l, LongType.INSTANCE);
    }

    public static Literal of(float f) {
        return new Literal(Float.valueOf(f), FloatType.INSTANCE);
    }

    public static Literal of(double d) {
        return new Literal(d, DoubleType.INSTANCE);
    }

    public static Literal of(String string) {
        return new Literal(string, StringType.INSTANCE);
    }

    public static Literal of(byte[] byArray) {
        return new Literal(byArray, BinaryType.INSTANCE);
    }

    public static Literal of(Date date) {
        return new Literal(date, DateType.INSTANCE);
    }

    public static Literal of(Timestamp timestamp) {
        return new Literal(timestamp, TimestampType.INSTANCE);
    }

    public static Literal ofNull(DataType dataType) {
        if (dataType instanceof ArrayType || dataType instanceof MapType || dataType instanceof StructType) {
            throw new IllegalArgumentException(dataType + " is an invalid data type for Literal.");
        }
        return new Literal(null, dataType);
    }

    private Literal(Object object, DataType dataType) {
        this.value = object;
        this.dataType = dataType;
    }

    public Object value() {
        return this.value;
    }

    @Override
    public Object eval(Row row) {
        return this.value;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Literal literal = (Literal)object;
        return Objects.equals(this.value, literal.value) && Objects.equals(this.dataType, literal.dataType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.dataType);
    }
}

