/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Scan;
import io.delta.kernel.ScanBuilder;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.internal.ScanImpl;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.Tuple2;
import java.util.Optional;

public class ScanBuilderImpl
implements ScanBuilder {
    private final StructType snapshotSchema;
    private final CloseableIterator<AddFile> filesIter;
    private final Lazy<Tuple2<Protocol, Metadata>> protocolAndMetadata;
    private final TableClient tableClient;
    private final Path dataPath;
    private StructType readSchema;
    private Optional<Expression> filter;

    public ScanBuilderImpl(Path path, Lazy<Tuple2<Protocol, Metadata>> lazy, StructType structType, CloseableIterator<AddFile> closeableIterator, TableClient tableClient) {
        this.dataPath = path;
        this.snapshotSchema = structType;
        this.filesIter = closeableIterator;
        this.protocolAndMetadata = lazy;
        this.tableClient = tableClient;
        this.readSchema = structType;
        this.filter = Optional.empty();
    }

    @Override
    public ScanBuilder withFilter(TableClient tableClient, Expression expression) {
        if (this.filter.isPresent()) {
            throw new IllegalArgumentException("There already exists a filter in current builder");
        }
        this.filter = Optional.of(expression);
        return this;
    }

    @Override
    public ScanBuilder withReadSchema(TableClient tableClient, StructType structType) {
        this.readSchema = structType;
        return this;
    }

    @Override
    public Scan build() {
        return new ScanImpl(this.snapshotSchema, this.readSchema, this.protocolAndMetadata, this.filesIter, this.filter, this.dataPath);
    }
}

