/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Scan;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.data.AddFileColumnarBatch;
import io.delta.kernel.internal.data.ScanStateRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.internal.types.TableSchemaSerDe;
import io.delta.kernel.internal.util.InternalSchemaUtils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.Tuple2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;

public class ScanImpl
implements Scan {
    private final StructType snapshotSchema;
    private final Path dataPath;
    private final StructType readSchema;
    private final CloseableIterator<AddFile> filesIter;
    private final Lazy<Tuple2<Protocol, Metadata>> protocolAndMetadata;
    private final Optional<Expression> filter;
    private boolean accessedScanFiles;

    public ScanImpl(StructType structType, StructType structType2, Lazy<Tuple2<Protocol, Metadata>> lazy, CloseableIterator<AddFile> closeableIterator, Optional<Expression> optional, Path path) {
        this.snapshotSchema = structType;
        this.readSchema = structType2;
        this.protocolAndMetadata = lazy;
        this.filesIter = closeableIterator;
        this.dataPath = path;
        this.filter = optional;
    }

    @Override
    public CloseableIterator<ColumnarBatch> getScanFiles(TableClient tableClient) {
        if (this.accessedScanFiles) {
            throw new IllegalStateException("Scan files are already fetched from this instance");
        }
        this.accessedScanFiles = true;
        return new CloseableIterator<ColumnarBatch>(){
            private Optional<AddFile> nextValid = Optional.empty();
            private boolean closed;

            @Override
            public boolean hasNext() {
                if (this.closed) {
                    throw new IllegalStateException("Can't call `hasNext` on a closed iterator.");
                }
                if (!this.nextValid.isPresent()) {
                    this.nextValid = this.findNextValid();
                }
                return this.nextValid.isPresent();
            }

            @Override
            public ColumnarBatch next() {
                if (this.closed) {
                    throw new IllegalStateException("Can't call `next` on a closed iterator.");
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArrayList<AddFile> arrayList = new ArrayList<AddFile>();
                do {
                    arrayList.add(this.nextValid.get());
                    this.nextValid = Optional.empty();
                } while (arrayList.size() < 8 && this.hasNext());
                return new AddFileColumnarBatch(Collections.unmodifiableList(arrayList));
            }

            @Override
            public void close() throws IOException {
                ScanImpl.this.filesIter.close();
                this.closed = true;
            }

            private Optional<AddFile> findNextValid() {
                if (ScanImpl.this.filesIter.hasNext()) {
                    return Optional.of(ScanImpl.this.filesIter.next());
                }
                return Optional.empty();
            }
        };
    }

    @Override
    public Row getScanState(TableClient tableClient) {
        return new ScanStateRow((Metadata)this.protocolAndMetadata.get()._2, (Protocol)this.protocolAndMetadata.get()._1, TableSchemaSerDe.toJson(this.readSchema), TableSchemaSerDe.toJson(InternalSchemaUtils.convertToPhysicalSchema(this.readSchema, this.snapshotSchema, ((Metadata)this.protocolAndMetadata.get()._2).getConfiguration().getOrDefault("delta.columnMapping.mode", "none"))), this.dataPath.toUri().toString());
    }

    @Override
    public Optional<Expression> getRemainingFilter() {
        return this.filter;
    }
}

