/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.FileAction;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.Utils;
import java.util.Collections;
import java.util.Map;

public class AddCDCFile
extends FileAction {
    public static final StructType READ_SCHEMA = new StructType().add("path", (DataType)StringType.INSTANCE, false).add("partitionValues", (DataType)new MapType(StringType.INSTANCE, StringType.INSTANCE, true), false).add("size", (DataType)LongType.INSTANCE, false).add("dataChange", (DataType)BooleanType.INSTANCE, false);
    private final Map<String, String> partitionValues;
    private final long size;

    public static AddCDCFile fromRow(Row row) {
        if (row == null) {
            return null;
        }
        String string = Utils.requireNonNull(row, 0, "path").getString(0);
        Map<String, String> map = row.getMap(1);
        long l = Utils.requireNonNull(row, 2, "size").getLong(2);
        boolean bl = Utils.requireNonNull(row, 3, "dataChange").getBoolean(3);
        return new AddCDCFile(string, map, l, bl);
    }

    public AddCDCFile(String string, Map<String, String> map, long l, boolean bl) {
        super(string, bl);
        this.partitionValues = map == null ? Collections.emptyMap() : map;
        this.size = l;
    }

    @Override
    public AddCDCFile copyWithDataChange(boolean bl) {
        if (this.dataChange == bl) {
            return this;
        }
        return new AddCDCFile(this.path, this.partitionValues, this.size, bl);
    }

    public AddCDCFile withAbsolutePath(Path path) {
        Path path2 = new Path(this.path);
        if (path2.isAbsolute()) {
            return this;
        }
        Path path3 = new Path(path, path2);
        return new AddCDCFile(path3.toString(), this.partitionValues, this.size, this.dataChange);
    }

    public Map<String, String> getPartitionValues() {
        return Collections.unmodifiableMap(this.partitionValues);
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        return "AddCDCFile{path='" + this.path + '\'' + ", partitionValues=" + this.partitionValues + ", size=" + this.size + ", dataChange=" + this.dataChange + '}';
    }
}

