/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.actions.FileAction;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.Utils;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class AddFile
extends FileAction {
    public static final StructType READ_SCHEMA = new StructType().add("path", (DataType)StringType.INSTANCE, false).add("partitionValues", (DataType)new MapType(StringType.INSTANCE, StringType.INSTANCE, true), false).add("size", (DataType)LongType.INSTANCE, false).add("modificationTime", (DataType)LongType.INSTANCE, false).add("dataChange", (DataType)BooleanType.INSTANCE, false).add("deletionVector", (DataType)DeletionVectorDescriptor.READ_SCHEMA, true);
    private final Map<String, String> partitionValues;
    private final long size;
    private final long modificationTime;
    private final DeletionVectorDescriptor deletionVector;

    public static AddFile fromRow(Row row) {
        if (row == null) {
            return null;
        }
        String string = Utils.requireNonNull(row, 0, "path").getString(0);
        Map<String, String> map = row.getMap(1);
        long l = Utils.requireNonNull(row, 2, "size").getLong(2);
        long l2 = Utils.requireNonNull(row, 3, "modificationTime").getLong(3);
        boolean bl = Utils.requireNonNull(row, 4, "dataChange").getBoolean(4);
        DeletionVectorDescriptor deletionVectorDescriptor = DeletionVectorDescriptor.fromRow(row.getStruct(5));
        return new AddFile(string, map, l, l2, bl, deletionVectorDescriptor);
    }

    public AddFile(String string, Map<String, String> map, long l, long l2, boolean bl, DeletionVectorDescriptor deletionVectorDescriptor) {
        super(string, bl);
        this.partitionValues = map == null ? Collections.emptyMap() : map;
        this.size = l;
        this.modificationTime = l2;
        this.deletionVector = deletionVectorDescriptor;
    }

    @Override
    public AddFile copyWithDataChange(boolean bl) {
        if (this.dataChange == bl) {
            return this;
        }
        return new AddFile(this.path, this.partitionValues, this.size, this.modificationTime, bl, this.deletionVector);
    }

    public AddFile withAbsolutePath(Path path) {
        Path path2 = new Path(this.path);
        if (path2.isAbsolute()) {
            return this;
        }
        Path path3 = new Path(path, path2);
        return new AddFile(path3.toString(), this.partitionValues, this.size, this.modificationTime, this.dataChange, this.deletionVector);
    }

    public Map<String, String> getPartitionValues() {
        return Collections.unmodifiableMap(this.partitionValues);
    }

    public long getSize() {
        return this.size;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public DeletionVectorDescriptor getDeletionVector() {
        return this.deletionVector;
    }

    public Optional<String> getDeletionVectorUniqueId() {
        return Optional.ofNullable(this.deletionVector).map(deletionVectorDescriptor -> deletionVectorDescriptor.getUniqueId());
    }

    public Row getDeletionVectorAsRow() {
        if (this.deletionVector == null) {
            return null;
        }
        return this.deletionVector.toRow();
    }

    public String toString() {
        return "AddFile{path='" + this.path + '\'' + ", partitionValues=" + this.partitionValues + ", size=" + this.size + ", modificationTime=" + this.modificationTime + ", dataChange=" + this.dataChange + ", deletionVector=" + this.deletionVector + '}';
    }
}

