/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.internal.actions.Action;
import io.delta.kernel.internal.lang.Lazy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public abstract class FileAction
implements Action {
    protected final String path;
    protected final boolean dataChange;
    private final Lazy<URI> pathAsUri;

    public FileAction(String string, boolean bl) {
        this.path = Objects.requireNonNull(string, "path is null");
        this.dataChange = bl;
        this.pathAsUri = new Lazy<URI>(() -> {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        });
    }

    public String getPath() {
        return this.path;
    }

    public boolean isDataChange() {
        return this.dataChange;
    }

    public URI toURI() {
        return this.pathAsUri.get();
    }

    public abstract FileAction copyWithDataChange(boolean var1);
}

