/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.Action;
import io.delta.kernel.internal.actions.Format;
import io.delta.kernel.internal.types.TableSchemaSerDe;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Metadata
implements Action {
    public static final StructType READ_SCHEMA = new StructType().add("id", (DataType)StringType.INSTANCE, false).add("name", (DataType)StringType.INSTANCE, true).add("description", (DataType)StringType.INSTANCE, true).add("format", (DataType)Format.READ_SCHEMA, false).add("schemaString", (DataType)StringType.INSTANCE, false).add("partitionColumns", (DataType)new ArrayType(StringType.INSTANCE, false), false).add("createdTime", (DataType)LongType.INSTANCE, true).add("configuration", (DataType)new MapType(StringType.INSTANCE, StringType.INSTANCE, false), false);
    private final String id;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Format format;
    private final String schemaString;
    private final StructType schema;
    private final List<String> partitionColumns;
    private final Optional<Long> createdTime;
    private final Map<String, String> configuration;

    public static Metadata fromRow(Row row, TableClient tableClient) {
        if (row == null) {
            return null;
        }
        String string = Utils.requireNonNull(row, 4, "schemaString").getString(4);
        StructType structType = TableSchemaSerDe.fromJson(tableClient.getJsonHandler(), string);
        return new Metadata(Utils.requireNonNull(row, 0, "id").getString(0), Optional.ofNullable(row.isNullAt(1) ? null : row.getString(1)), Optional.ofNullable(row.isNullAt(2) ? null : row.getString(2)), Format.fromRow(Utils.requireNonNull(row, 0, "id").getStruct(3)), string, structType, row.getArray(5), Optional.ofNullable(row.isNullAt(6) ? null : Long.valueOf(row.getLong(6))), row.getMap(7));
    }

    public Metadata(String string, Optional<String> optional, Optional<String> optional2, Format format, String string2, StructType structType, List<String> list, Optional<Long> optional3, Map<String, String> map) {
        this.id = Objects.requireNonNull(string, "id is null");
        this.name = optional;
        this.description = Objects.requireNonNull(optional2, "description is null");
        this.format = Objects.requireNonNull(format, "format is null");
        this.schemaString = Objects.requireNonNull(string2, "schemaString is null");
        this.schema = structType;
        this.partitionColumns = list == null ? Collections.emptyList() : list;
        this.createdTime = optional3;
        this.configuration = map == null ? Collections.emptyMap() : map;
    }

    public String getSchemaString() {
        return this.schemaString;
    }

    public StructType getSchema() {
        return this.schema;
    }

    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Format getFormat() {
        return this.format;
    }

    public Optional<Long> getCreatedTime() {
        return this.createdTime;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }
}

