/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.Action;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.Collections;
import java.util.List;

public class Protocol
implements Action {
    public static final StructType READ_SCHEMA = new StructType().add("minReaderVersion", (DataType)IntegerType.INSTANCE, false).add("minWriterVersion", (DataType)IntegerType.INSTANCE, false).add("readerFeatures", new ArrayType(StringType.INSTANCE, false)).add("writerFeatures", new ArrayType(StringType.INSTANCE, false));
    private final int minReaderVersion;
    private final int minWriterVersion;
    private final List<String> readerFeatures;
    private final List<String> writerFeatures;

    public static Protocol fromRow(Row row) {
        if (row == null) {
            return null;
        }
        return new Protocol(row.getInt(0), row.getInt(1), row.isNullAt(2) ? Collections.emptyList() : row.getArray(2), row.isNullAt(3) ? Collections.emptyList() : row.getArray(3));
    }

    public Protocol(int n, int n2, List<String> list, List<String> list2) {
        this.minReaderVersion = n;
        this.minWriterVersion = n2;
        this.readerFeatures = list;
        this.writerFeatures = list2;
    }

    public int getMinReaderVersion() {
        return this.minReaderVersion;
    }

    public int getMinWriterVersion() {
        return this.minWriterVersion;
    }

    public List<String> getReaderFeatures() {
        return this.readerFeatures;
    }

    public List<String> getWriterFeatures() {
        return this.writerFeatures;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Protocol{");
        stringBuilder.append("minReaderVersion=").append(this.minReaderVersion);
        stringBuilder.append(", minWriterVersion=").append(this.minWriterVersion);
        stringBuilder.append(", readerFeatures=").append(this.readerFeatures);
        stringBuilder.append(", writerFeatures=").append(this.writerFeatures);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

