/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.actions.FileAction;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.Utils;
import java.util.Map;
import java.util.Optional;

public class RemoveFile
extends FileAction {
    public static final StructType READ_SCHEMA = new StructType().add("path", (DataType)StringType.INSTANCE, false).add("deletionTimestamp", LongType.INSTANCE).add("partitionValues", new MapType(StringType.INSTANCE, StringType.INSTANCE, true)).add("size", LongType.INSTANCE).add("dataChange", (DataType)BooleanType.INSTANCE, false).add("deletionVector", (DataType)DeletionVectorDescriptor.READ_SCHEMA, true);
    private final long deletionTimestamp;
    private final Map<String, String> partitionValues;
    private final long size;
    private final DeletionVectorDescriptor deletionVector;

    public static RemoveFile fromRow(Row row) {
        if (row == null) {
            return null;
        }
        String string = Utils.requireNonNull(row, 0, "path").getString(0);
        long l = row.getLong(1);
        Map<String, String> map = row.getMap(2);
        long l2 = row.getLong(3);
        boolean bl = Utils.requireNonNull(row, 4, "dataChange").getBoolean(4);
        DeletionVectorDescriptor deletionVectorDescriptor = DeletionVectorDescriptor.fromRow(row.getStruct(5));
        return new RemoveFile(string, l, map, l2, bl, deletionVectorDescriptor);
    }

    public RemoveFile(String string, long l, Map<String, String> map, long l2, boolean bl, DeletionVectorDescriptor deletionVectorDescriptor) {
        super(string, bl);
        this.deletionTimestamp = l;
        this.partitionValues = map;
        this.size = l2;
        this.deletionVector = deletionVectorDescriptor;
    }

    @Override
    public RemoveFile copyWithDataChange(boolean bl) {
        if (this.dataChange == bl) {
            return this;
        }
        return new RemoveFile(this.path, this.deletionTimestamp, this.partitionValues, this.size, bl, this.deletionVector);
    }

    public Optional<String> getDeletionVectorUniqueId() {
        return Optional.ofNullable(this.deletionVector).map(deletionVectorDescriptor -> deletionVectorDescriptor.getUniqueId());
    }

    public RemoveFile withAbsolutePath(Path path) {
        Path path2 = new Path(this.path);
        if (path2.isAbsolute()) {
            return this;
        }
        Path path3 = new Path(path, path2);
        return new RemoveFile(path3.toString(), this.deletionTimestamp, this.partitionValues, this.size, this.dataChange, this.deletionVector);
    }
}

