/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.Action;
import io.delta.kernel.internal.actions.AddCDCFile;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.CommitInfo;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.RemoveFile;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.types.StructType;

public class SingleAction {
    public static StructType READ_SCHEMA = new StructType().add("txn", SetTransaction.READ_SCHEMA).add("add", AddFile.READ_SCHEMA).add("remove", RemoveFile.READ_SCHEMA).add("metaData", Metadata.READ_SCHEMA).add("protocol", Protocol.READ_SCHEMA).add("cdc", AddCDCFile.READ_SCHEMA).add("commitInfo", CommitInfo.READ_SCHEMA);
    private final SetTransaction txn;
    private final AddFile add;
    private final RemoveFile remove;
    private final Metadata metadata;
    private final Protocol protocol;
    private final AddCDCFile cdc;
    private final CommitInfo commitInfo;

    public static SingleAction fromRow(Row row, TableClient tableClient) {
        if (!row.isNullAt(0)) {
            SetTransaction setTransaction = SetTransaction.fromRow(row.getStruct(0));
            return new SingleAction(setTransaction, null, null, null, null, null, null);
        }
        if (!row.isNullAt(1)) {
            AddFile addFile = AddFile.fromRow(row.getStruct(1));
            return new SingleAction(null, addFile, null, null, null, null, null);
        }
        if (!row.isNullAt(2)) {
            RemoveFile removeFile = RemoveFile.fromRow(row.getStruct(2));
            return new SingleAction(null, null, removeFile, null, null, null, null);
        }
        if (!row.isNullAt(3)) {
            Metadata metadata = Metadata.fromRow(row.getStruct(3), tableClient);
            return new SingleAction(null, null, null, metadata, null, null, null);
        }
        if (!row.isNullAt(4)) {
            Protocol protocol = Protocol.fromRow(row.getStruct(4));
            return new SingleAction(null, null, null, null, protocol, null, null);
        }
        if (!row.isNullAt(5)) {
            AddCDCFile addCDCFile = AddCDCFile.fromRow(row.getStruct(5));
            return new SingleAction(null, null, null, null, null, addCDCFile, null);
        }
        if (!row.isNullAt(6)) {
            CommitInfo commitInfo = CommitInfo.fromRow(row.getStruct(6));
            return new SingleAction(null, null, null, null, null, null, commitInfo);
        }
        throw new IllegalStateException("SingleAction row contained no non-null actions");
    }

    private SingleAction(SetTransaction setTransaction, AddFile addFile, RemoveFile removeFile, Metadata metadata, Protocol protocol, AddCDCFile addCDCFile, CommitInfo commitInfo) {
        this.txn = setTransaction;
        this.add = addFile;
        this.remove = removeFile;
        this.metadata = metadata;
        this.protocol = protocol;
        this.cdc = addCDCFile;
        this.commitInfo = commitInfo;
    }

    public Action unwrap() {
        if (this.txn != null) {
            return this.txn;
        }
        if (this.add != null) {
            return this.add;
        }
        if (this.remove != null) {
            return this.remove;
        }
        if (this.metadata != null) {
            return this.metadata;
        }
        if (this.protocol != null) {
            return this.protocol;
        }
        if (this.cdc != null) {
            return this.cdc;
        }
        if (this.commitInfo != null) {
            return this.commitInfo;
        }
        throw new IllegalStateException("SingleAction row contained no non-null actions");
    }
}

