/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checkpoints;

import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.FileNames;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class CheckpointInstance
implements Comparable<CheckpointInstance> {
    public static final CheckpointInstance MAX_VALUE = new CheckpointInstance(-1L);
    public final long version;
    public final Optional<Integer> numParts;

    public CheckpointInstance(Path path) {
        this(FileNames.getFileVersion(path));
    }

    public CheckpointInstance(long l) {
        this(l, Optional.empty());
    }

    public CheckpointInstance(long l, Optional<Integer> optional) {
        this.version = l;
        this.numParts = optional;
        if (optional.isPresent()) {
            throw new UnsupportedOperationException("Reading Delta tables with mulit-part checkpoint is not yet supported");
        }
    }

    boolean isNotLaterThan(CheckpointInstance checkpointInstance) {
        if (checkpointInstance == MAX_VALUE) {
            return true;
        }
        return this.version <= checkpointInstance.version;
    }

    public List<Path> getCorrespondingFiles(Path path) {
        if (this == MAX_VALUE) {
            throw new IllegalStateException("Can't get files for CheckpointVersion.MaxValue.");
        }
        return this.numParts.map(n -> FileNames.checkpointFileWithParts(path, this.version, n)).orElseGet(() -> Collections.singletonList(FileNames.checkpointFileSingular(path, this.version)));
    }

    @Override
    public int compareTo(CheckpointInstance checkpointInstance) {
        if (this.version == checkpointInstance.version) {
            return this.numParts.orElse(1) - checkpointInstance.numParts.orElse(1);
        }
        return Long.compare(this.version, checkpointInstance.version);
    }

    public String toString() {
        return "CheckpointInstance{version=" + this.version + ", numParts=" + this.numParts + "}";
    }
}

