/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.data.PojoColumnarBatch;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AddFileColumnarBatch
extends PojoColumnarBatch {
    private static final Map<Integer, Function<AddFile, Object>> ordinalToAccessor = new HashMap<Integer, Function<AddFile, Object>>();
    private static final Map<Integer, String> ordinalToColName = new HashMap<Integer, String>();
    private static final Map<String, Integer> colNameToOrdinal;

    public static int getDeletionVectorColOrdinal() {
        return colNameToOrdinal.get("deletionVector");
    }

    public AddFileColumnarBatch(List<AddFile> list) {
        super(Objects.requireNonNull(list, "addFiles is null"), AddFile.READ_SCHEMA, ordinalToAccessor, ordinalToColName);
    }

    static {
        ordinalToAccessor.put(0, addFile -> addFile.getPath());
        ordinalToAccessor.put(1, addFile -> addFile.getPartitionValues());
        ordinalToAccessor.put(2, addFile -> addFile.getSize());
        ordinalToAccessor.put(3, addFile -> addFile.getModificationTime());
        ordinalToAccessor.put(4, addFile -> addFile.isDataChange());
        ordinalToAccessor.put(5, addFile -> addFile.getDeletionVectorAsRow());
        ordinalToColName.put(0, "path");
        ordinalToColName.put(1, "partitionValues");
        ordinalToColName.put(2, "size");
        ordinalToColName.put(3, "modificationTime");
        ordinalToColName.put(4, "dataChange");
        ordinalToColName.put(5, "deletionVector");
        colNameToOrdinal = ordinalToColName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }
}

