/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.types.StructType;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ColumnarBatchRow
implements Row {
    private final ColumnarBatch columnarBatch;
    private final int rowId;

    public ColumnarBatchRow(ColumnarBatch columnarBatch, int n) {
        this.columnarBatch = Objects.requireNonNull(columnarBatch, "columnarBatch is null");
        this.rowId = n;
    }

    @Override
    public StructType getSchema() {
        return this.columnarBatch.getSchema();
    }

    @Override
    public boolean isNullAt(int n) {
        return this.columnVector(n).isNullAt(this.rowId);
    }

    @Override
    public boolean getBoolean(int n) {
        return this.columnVector(n).getBoolean(this.rowId);
    }

    @Override
    public byte getByte(int n) {
        return this.columnVector(n).getByte(this.rowId);
    }

    @Override
    public short getShort(int n) {
        return this.columnVector(n).getShort(this.rowId);
    }

    @Override
    public int getInt(int n) {
        return this.columnVector(n).getInt(this.rowId);
    }

    @Override
    public long getLong(int n) {
        return this.columnVector(n).getLong(this.rowId);
    }

    @Override
    public float getFloat(int n) {
        return this.columnVector(n).getFloat(this.rowId);
    }

    @Override
    public double getDouble(int n) {
        return this.columnVector(n).getDouble(this.rowId);
    }

    @Override
    public String getString(int n) {
        return this.columnVector(n).getString(this.rowId);
    }

    @Override
    public byte[] getBinary(int n) {
        return this.columnVector(n).getBinary(this.rowId);
    }

    @Override
    public Row getStruct(int n) {
        return this.columnVector(n).getStruct(this.rowId);
    }

    @Override
    public <T> List<T> getArray(int n) {
        return this.columnVector(n).getArray(this.rowId);
    }

    @Override
    public <K, V> Map<K, V> getMap(int n) {
        return this.columnVector(n).getMap(this.rowId);
    }

    private ColumnVector columnVector(int n) {
        return this.columnarBatch.getColumnVector(n);
    }
}

