/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.Row;
import io.delta.kernel.types.StructType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartitionRow
implements Row {
    private final StructType schema;
    private final Map<Integer, String> ordinalToValue = new HashMap<Integer, String>();

    public PartitionRow(StructType structType, Map<String, Integer> map, Map<String, String> map2) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string = entry.getKey();
            int n = entry.getValue();
            String string2 = map2.get(string);
            this.ordinalToValue.put(n, string2);
        }
        this.schema = structType;
    }

    @Override
    public StructType getSchema() {
        return this.schema;
    }

    @Override
    public boolean isNullAt(int n) {
        return this.ordinalToValue.get(n) == null;
    }

    @Override
    public boolean getBoolean(int n) {
        return Boolean.parseBoolean(this.ordinalToValue.get(n));
    }

    @Override
    public byte getByte(int n) {
        return Byte.parseByte(this.ordinalToValue.get(n));
    }

    @Override
    public short getShort(int n) {
        return Short.parseShort(this.ordinalToValue.get(n));
    }

    @Override
    public int getInt(int n) {
        return Integer.parseInt(this.ordinalToValue.get(n));
    }

    @Override
    public long getLong(int n) {
        return Long.parseLong(this.ordinalToValue.get(n));
    }

    @Override
    public float getFloat(int n) {
        return Float.parseFloat(this.ordinalToValue.get(n));
    }

    @Override
    public double getDouble(int n) {
        return Double.parseDouble(this.ordinalToValue.get(n));
    }

    @Override
    public String getString(int n) {
        return this.ordinalToValue.get(n);
    }

    @Override
    public byte[] getBinary(int n) {
        return this.ordinalToValue.get(n).getBytes();
    }

    @Override
    public Row getStruct(int n) {
        throw new UnsupportedOperationException("Partition values can't be StructTypes");
    }

    @Override
    public <T> List<T> getArray(int n) {
        throw new UnsupportedOperationException("Partition values can't be ArrayType");
    }

    @Override
    public <K, V> Map<K, V> getMap(int n) {
        throw new UnsupportedOperationException("Partition values can't be MapType");
    }
}

