/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class PojoColumnarBatch<POJO_TYPE>
implements ColumnarBatch {
    private final List<POJO_TYPE> pojoObjects;
    private final StructType schema;
    private final Map<Integer, Function<POJO_TYPE, Object>> ordinalToAccessor;
    private final Map<Integer, String> ordinalToColName;

    public PojoColumnarBatch(List<POJO_TYPE> list, StructType structType, Map<Integer, Function<POJO_TYPE, Object>> map, Map<Integer, String> map2) {
        this.pojoObjects = Objects.requireNonNull(list, "pojoObjects is null");
        this.schema = Objects.requireNonNull(structType, "schema is null");
        this.ordinalToAccessor = Objects.requireNonNull(map, "ordinalToAccessor is null");
        this.ordinalToColName = Objects.requireNonNull(map2, "ordinalToColName is null");
    }

    @Override
    public StructType getSchema() {
        return this.schema;
    }

    @Override
    public ColumnVector getColumnVector(final int n) {
        return new ColumnVector(){
            private DataType dataType = this.getDataType();

            @Override
            public DataType getDataType() {
                return PojoColumnarBatch.this.getSchema().at(n).getDataType();
            }

            @Override
            public int getSize() {
                return PojoColumnarBatch.this.pojoObjects.size();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean isNullAt(int n2) {
                return this.getValue(n2) == null;
            }

            @Override
            public boolean getBoolean(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof BooleanType, "boolean");
                return (Boolean)this.getValue(n2);
            }

            @Override
            public byte getByte(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof ByteType, "byte");
                return (Byte)this.getValue(n2);
            }

            @Override
            public short getShort(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof ShortType, "short");
                return (Short)this.getValue(n2);
            }

            @Override
            public int getInt(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof IntegerType, "integer");
                return (Integer)this.getValue(n2);
            }

            @Override
            public long getLong(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof LongType, "long");
                return (Long)this.getValue(n2);
            }

            @Override
            public float getFloat(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof FloatType, "float");
                return ((Float)this.getValue(n2)).floatValue();
            }

            @Override
            public double getDouble(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof DoubleType, "double");
                return (Double)this.getValue(n2);
            }

            @Override
            public byte[] getBinary(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof BinaryType, "binary");
                return (byte[])this.getValue(n2);
            }

            @Override
            public String getString(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof StringType, "string");
                return (String)this.getValue(n2);
            }

            @Override
            public <K, V> Map<K, V> getMap(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof MapType, "map");
                return (Map)((Function)PojoColumnarBatch.this.ordinalToAccessor.get(n)).apply(PojoColumnarBatch.this.pojoObjects.get(n2));
            }

            @Override
            public Row getStruct(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof StructType, "struct");
                return (Row)((Function)PojoColumnarBatch.this.ordinalToAccessor.get(n)).apply(PojoColumnarBatch.this.pojoObjects.get(n2));
            }

            @Override
            public <T> List<T> getArray(int n2) {
                this.throwIfUnsafeAccess(this.dataType instanceof ArrayType, "array");
                return (List)((Function)PojoColumnarBatch.this.ordinalToAccessor.get(n)).apply(PojoColumnarBatch.this.pojoObjects.get(n2));
            }

            private Object getValue(int n2) {
                return ((Function)PojoColumnarBatch.this.ordinalToAccessor.get(n)).apply(PojoColumnarBatch.this.pojoObjects.get(n2));
            }

            private void throwIfUnsafeAccess(boolean bl, String string) {
                if (!bl) {
                    String string2 = String.format("Trying to access a `%s` value from vector of type `%s`", string, this.dataType);
                    throw new UnsupportedOperationException(string2);
                }
            }
        };
    }

    @Override
    public int getSize() {
        return this.pojoObjects.size();
    }
}

