/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.Row;
import io.delta.kernel.types.StructType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class PojoRow<POJO_TYPE>
implements Row {
    private final POJO_TYPE pojoObject;
    private final StructType schema;
    private final Map<Integer, Function<POJO_TYPE, Object>> ordinalToAccessor;

    public PojoRow(POJO_TYPE POJO_TYPE, StructType structType, Map<Integer, Function<POJO_TYPE, Object>> map) {
        this.pojoObject = Objects.requireNonNull(POJO_TYPE, "pojoObjects is null");
        this.schema = Objects.requireNonNull(structType, "schema is null");
        this.ordinalToAccessor = Objects.requireNonNull(map, "ordinalToAccessor is null");
    }

    @Override
    public StructType getSchema() {
        return this.schema;
    }

    @Override
    public boolean isNullAt(int n) {
        return this.getValue(n) == null;
    }

    @Override
    public boolean getBoolean(int n) {
        return (Boolean)this.getValue(n);
    }

    @Override
    public byte getByte(int n) {
        return (Byte)this.getValue(n);
    }

    @Override
    public short getShort(int n) {
        return (Short)this.getValue(n);
    }

    @Override
    public int getInt(int n) {
        return (Integer)this.getValue(n);
    }

    @Override
    public long getLong(int n) {
        return (Long)this.getValue(n);
    }

    @Override
    public float getFloat(int n) {
        return ((Float)this.getValue(n)).floatValue();
    }

    @Override
    public double getDouble(int n) {
        return (Double)this.getValue(n);
    }

    @Override
    public String getString(int n) {
        return (String)this.getValue(n);
    }

    @Override
    public byte[] getBinary(int n) {
        return (byte[])this.getValue(n);
    }

    @Override
    public Row getStruct(int n) {
        return (Row)this.getValue(n);
    }

    @Override
    public <T> List<T> getArray(int n) {
        return (List)this.getValue(n);
    }

    @Override
    public <K, V> Map<K, V> getMap(int n) {
        return (Map)this.getValue(n);
    }

    private Object getValue(int n) {
        return this.ordinalToAccessor.get(n).apply(this.pojoObject);
    }
}

