/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ScanStateRow
implements Row {
    private static final Map<Integer, Function<ScanStateRow, Object>> ordinalToAccessor = new HashMap<Integer, Function<ScanStateRow, Object>>();
    private static final Map<Integer, String> ordinalToColName = new HashMap<Integer, String>();
    private static final StructType schema = new StructType().add("configuration", new MapType(StringType.INSTANCE, StringType.INSTANCE, false)).add("logicalSchemaString", StringType.INSTANCE).add("physicalSchemaString", StringType.INSTANCE).add("partitionColumns", new ArrayType(StringType.INSTANCE, false)).add("minReaderVersion", IntegerType.INSTANCE).add("minWriterVersion", IntegerType.INSTANCE).add("tablePath", StringType.INSTANCE);
    private static final Map<String, Integer> colNameToOrdinal;
    private final Map<String, String> configuration;
    private final List<String> partitionColumns;
    private final int minReaderVersion;
    private final int minWriterVersion;
    private final String readSchemaLogicalJson;
    private final String readSchemaPhysicalJson;
    private String tablePath;

    public static int getLogicalSchemaStringColOrdinal() {
        return ScanStateRow.getOrdinal("logicalSchemaString");
    }

    public static int getPhysicalSchemaStringColOrdinal() {
        return ScanStateRow.getOrdinal("physicalSchemaString");
    }

    public static int getPartitionColumnsColOrdinal() {
        return ScanStateRow.getOrdinal("partitionColumns");
    }

    public static int getConfigurationColOrdinal() {
        return ScanStateRow.getOrdinal("configuration");
    }

    public static String getTablePath(Row row) {
        return row.getString(ScanStateRow.getOrdinal("tablePath"));
    }

    public ScanStateRow(Metadata metadata, Protocol protocol, String string, String string2, String string3) {
        this.configuration = metadata.getConfiguration();
        this.partitionColumns = metadata.getPartitionColumns();
        this.minReaderVersion = protocol.getMinReaderVersion();
        this.minWriterVersion = protocol.getMinWriterVersion();
        this.readSchemaLogicalJson = string;
        this.readSchemaPhysicalJson = string2;
        this.tablePath = string3;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public int getMinReaderVersion() {
        return this.minReaderVersion;
    }

    public int getMinWriterVersion() {
        return this.minWriterVersion;
    }

    public String getReadSchemaPhysicalJson() {
        return this.readSchemaPhysicalJson;
    }

    public String getReadSchemaLogicalJson() {
        return this.readSchemaLogicalJson;
    }

    public String getTablePath() {
        return this.tablePath;
    }

    @Override
    public StructType getSchema() {
        return schema;
    }

    @Override
    public boolean isNullAt(int n) {
        return this.getValue(n) == null;
    }

    @Override
    public boolean getBoolean(int n) {
        this.throwIfUnsafeAccess(n, BooleanType.class, "boolean");
        return (Boolean)this.getValue(n);
    }

    @Override
    public byte getByte(int n) {
        this.throwIfUnsafeAccess(n, ByteType.class, "byte");
        return (Byte)this.getValue(n);
    }

    @Override
    public short getShort(int n) {
        this.throwIfUnsafeAccess(n, ShortType.class, "short");
        return (Short)this.getValue(n);
    }

    @Override
    public int getInt(int n) {
        this.throwIfUnsafeAccess(n, IntegerType.class, "integer");
        return (Integer)this.getValue(n);
    }

    @Override
    public long getLong(int n) {
        this.throwIfUnsafeAccess(n, LongType.class, "long");
        return (Long)this.getValue(n);
    }

    @Override
    public float getFloat(int n) {
        this.throwIfUnsafeAccess(n, FloatType.class, "float");
        return ((Float)this.getValue(n)).floatValue();
    }

    @Override
    public double getDouble(int n) {
        this.throwIfUnsafeAccess(n, DoubleType.class, "double");
        return (Double)this.getValue(n);
    }

    @Override
    public String getString(int n) {
        this.throwIfUnsafeAccess(n, StringType.class, "string");
        return (String)this.getValue(n);
    }

    @Override
    public byte[] getBinary(int n) {
        this.throwIfUnsafeAccess(n, BinaryType.class, "binary");
        return (byte[])this.getValue(n);
    }

    @Override
    public Row getStruct(int n) {
        this.throwIfUnsafeAccess(n, StructType.class, "struct");
        return (Row)this.getValue(n);
    }

    @Override
    public <T> List<T> getArray(int n) {
        this.throwIfUnsafeAccess(n, ArrayType.class, "array");
        return (List)this.getValue(n);
    }

    @Override
    public <K, V> Map<K, V> getMap(int n) {
        this.throwIfUnsafeAccess(n, MapType.class, "map");
        return (Map)this.getValue(n);
    }

    private Object getValue(int n) {
        return ordinalToAccessor.get(n).apply(this);
    }

    private DataType dataType(int n) {
        if (schema.length() <= n) {
            throw new IllegalArgumentException("invalid ordinal: " + n);
        }
        return schema.at(n).getDataType();
    }

    private void throwIfUnsafeAccess(int n, Class<? extends DataType> clazz, String string) {
        DataType dataType = this.dataType(n);
        if (!clazz.isAssignableFrom(dataType.getClass())) {
            String string2 = String.format("Trying to access a `%s` value from vector of type `%s`", string, dataType);
            throw new UnsupportedOperationException(string2);
        }
    }

    private static int getOrdinal(String string) {
        return colNameToOrdinal.get(string);
    }

    static {
        ordinalToAccessor.put(0, scanStateRow -> scanStateRow.getConfiguration());
        ordinalToAccessor.put(1, scanStateRow -> scanStateRow.getReadSchemaLogicalJson());
        ordinalToAccessor.put(2, scanStateRow -> scanStateRow.getReadSchemaPhysicalJson());
        ordinalToAccessor.put(3, scanStateRow -> scanStateRow.getPartitionColumns());
        ordinalToAccessor.put(4, scanStateRow -> scanStateRow.getMinReaderVersion());
        ordinalToAccessor.put(5, scanStateRow -> scanStateRow.getMinWriterVersion());
        ordinalToAccessor.put(6, scanStateRow -> scanStateRow.getTablePath());
        ordinalToColName.put(0, "configuration");
        ordinalToColName.put(1, "logicalSchemaString");
        ordinalToColName.put(2, "physicalSchemaString");
        ordinalToColName.put(3, "partitionColumns");
        ordinalToColName.put(4, "minReaderVersion");
        ordinalToColName.put(5, "minWriterVersion");
        ordinalToColName.put(6, "tablePath");
        colNameToOrdinal = ordinalToColName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }
}

