/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.deletionvectors;

import io.delta.kernel.internal.util.InternalUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;

public final class Base85Codec {
    static final long BASE = 85L;
    static final long BASE_2ND_POWER = 7225L;
    static final long BASE_3RD_POWER = 614125L;
    static final long BASE_4TH_POWER = 52200625L;
    static final int ASCII_BITMASK = 127;
    public static final int ENCODED_UUID_LENGTH = 20;
    public static final byte[] ENCODE_MAP = Base85Codec.getEncodeMap();
    public static final byte[] DECODE_MAP = Base85Codec.getDecodeMap();

    private static byte[] getEncodeMap() {
        int n;
        byte[] byArray = new byte[85];
        int n2 = 0;
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            byArray[n2] = (byte)n;
            ++n2;
        }
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            byArray[n2] = (byte)n;
            ++n2;
        }
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            byArray[n2] = (byte)n;
            ++n2;
        }
        for (char c : ".-:+=^!/*?&<>()[]{}@%$#".toCharArray()) {
            byArray[n2] = (byte)c;
            ++n2;
        }
        return byArray;
    }

    private static byte[] getDecodeMap() {
        InternalUtils.checkArgument(ENCODE_MAP.length - 1 <= 127);
        byte[] byArray = new byte[128];
        Arrays.fill(byArray, (byte)-1);
        for (int i = 0; i < ENCODE_MAP.length; ++i) {
            byte by = ENCODE_MAP[i];
            byArray[by] = (byte)i;
        }
        return byArray;
    }

    public static UUID decodeUUID(String string) {
        ByteBuffer byteBuffer = Base85Codec.decodeBlocks(string);
        return Base85Codec.uuidFromByteBuffer(byteBuffer);
    }

    public static byte[] decodeBytes(String string, int n) {
        ByteBuffer byteBuffer = Base85Codec.decodeBlocks(string);
        if (byteBuffer.remaining() > n) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return byArray;
        }
        return byteBuffer.array();
    }

    public static byte[] decodeAlignedBytes(String string) {
        return Base85Codec.decodeBlocks(string).array();
    }

    private static ByteBuffer decodeBlocks(String string) {
        char[] cArray = string.toCharArray();
        InternalUtils.checkArgument(cArray.length % 5 == 0, "input should be 5 character aligned");
        ByteBuffer byteBuffer = ByteBuffer.allocate(cArray.length / 5 * 4);
        int n = 0;
        class InputCharDecoder {
            int canary = 0;
            final /* synthetic */ char[] val$input;

            InputCharDecoder(char[] cArray) {
                this.val$input = cArray;
            }

            long decodeInputChar(int n) {
                char c = this.val$input[n];
                this.canary |= c;
                byte by = DECODE_MAP[c & 0x7F];
                this.canary |= by;
                return by;
            }
        }
        InputCharDecoder inputCharDecoder = new InputCharDecoder(cArray);
        while (byteBuffer.hasRemaining()) {
            long l = 0L;
            l += inputCharDecoder.decodeInputChar(n) * 52200625L;
            l += inputCharDecoder.decodeInputChar(n + 1) * 614125L;
            l += inputCharDecoder.decodeInputChar(n + 2) * 7225L;
            l += inputCharDecoder.decodeInputChar(n + 3) * 85L;
            byteBuffer.putInt((int)(l += inputCharDecoder.decodeInputChar(n + 4)));
            n += 5;
        }
        InternalUtils.checkArgument((inputCharDecoder.canary & 0xFFFFFF80) == 0, "Input is not valid Z85: " + string);
        byteBuffer.rewind();
        return byteBuffer;
    }

    private static UUID uuidFromByteBuffer(ByteBuffer byteBuffer) {
        InternalUtils.checkArgument(byteBuffer.remaining() >= 16);
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        return new UUID(l, l2);
    }

    public static String encodeUUID(UUID uUID) {
        ByteBuffer byteBuffer = Base85Codec.uuidToByteBuffer(uUID);
        return Base85Codec.encodeBlocks(byteBuffer);
    }

    private static ByteBuffer uuidToByteBuffer(UUID uUID) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(uUID.getMostSignificantBits());
        byteBuffer.putLong(uUID.getLeastSignificantBits());
        byteBuffer.rewind();
        return byteBuffer;
    }

    private static String encodeBlocks(ByteBuffer byteBuffer) {
        InternalUtils.checkArgument(byteBuffer.remaining() % 4 == 0);
        int n = byteBuffer.remaining() / 4;
        int n2 = n * 5;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (byteBuffer.hasRemaining()) {
            long l = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            byArray[n3] = ENCODE_MAP[(int)(l / 52200625L)];
            byArray[n3 + 1] = ENCODE_MAP[(int)((l %= 52200625L) / 614125L)];
            byArray[n3 + 2] = ENCODE_MAP[(int)((l %= 614125L) / 7225L)];
            byArray[n3 + 3] = ENCODE_MAP[(int)((l %= 7225L) / 85L)];
            byArray[n3 + 4] = ENCODE_MAP[(int)(l % 85L)];
            n3 += 5;
        }
        return new String(byArray, StandardCharsets.US_ASCII);
    }

    public static String encodeBytes(byte[] byArray) {
        if (byArray.length % 4 == 0) {
            return Base85Codec.encodeBlocks(ByteBuffer.wrap(byArray));
        }
        int n = (byArray.length + 4) / 4 * 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.put(byArray);
        while (byteBuffer.hasRemaining()) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.rewind();
        return Base85Codec.encodeBlocks(byteBuffer);
    }
}

