/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.lang;

import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Optional;

public abstract class FilteredCloseableIterator<RETURN_TYPE, ITER_TYPE>
implements CloseableIterator<RETURN_TYPE> {
    private final CloseableIterator<ITER_TYPE> iter;
    private Optional<RETURN_TYPE> nextValid;
    private boolean closed;

    public FilteredCloseableIterator(CloseableIterator<ITER_TYPE> closeableIterator) {
        this.iter = closeableIterator;
        this.nextValid = Optional.empty();
        this.closed = false;
    }

    protected abstract Optional<RETURN_TYPE> accept(ITER_TYPE var1);

    @Override
    public final boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `hasNext` on a closed iterator.");
        }
        if (!this.nextValid.isPresent()) {
            this.nextValid = this.findNextValid();
        }
        return this.nextValid.isPresent();
    }

    @Override
    public final RETURN_TYPE next() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `next` on a closed iterator.");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        RETURN_TYPE RETURN_TYPE = this.nextValid.get();
        this.nextValid = Optional.empty();
        return RETURN_TYPE;
    }

    @Override
    public final void close() throws IOException {
        this.iter.close();
        this.closed = true;
    }

    private Optional<RETURN_TYPE> findNextValid() {
        while (this.iter.hasNext()) {
            Optional<RETURN_TYPE> optional = this.accept(this.iter.next());
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }
}

