/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.client.TableClient;
import io.delta.kernel.fs.FileStatus;
import io.delta.kernel.internal.actions.Action;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.CloseableIterable;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.internal.replay.ReverseActionsToAddFilesIterator;
import io.delta.kernel.internal.replay.ReverseFilesToActionsIterable;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.Tuple2;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class LogReplay {
    private final Path dataPath;
    private final LogSegment logSegment;
    private final CloseableIterable<Tuple2<Action, Boolean>> reverseActionsIterable;
    private final Lazy<Tuple2<Protocol, Metadata>> protocolAndMetadata;

    public LogReplay(Path path, Path path2, TableClient tableClient, LogSegment logSegment) {
        this.dataPath = path2;
        this.logSegment = logSegment;
        Stream<FileStatus> stream = Stream.concat(logSegment.checkpoints.stream(), logSegment.deltas.stream());
        this.assertLogFilesBelongToTable(path, stream);
        this.reverseActionsIterable = new ReverseFilesToActionsIterable(tableClient, stream);
        this.protocolAndMetadata = new Lazy<Tuple2>(this::loadTableProtocolAndMetadata);
    }

    public Lazy<Tuple2<Protocol, Metadata>> lazyLoadProtocolAndMetadata() {
        return this.protocolAndMetadata;
    }

    public CloseableIterator<AddFile> getAddFiles() {
        CloseableIterator<Tuple2<Action, Boolean>> closeableIterator = this.reverseActionsIterable.iterator();
        return new ReverseActionsToAddFilesIterator(this.dataPath, closeableIterator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Tuple2<Protocol, Metadata> loadTableProtocolAndMetadata() {
        Protocol protocol = null;
        Metadata metadata = null;
        try (CloseableIterator<Tuple2<Action, Boolean>> closeableIterator = this.reverseActionsIterable.iterator();){
            while (closeableIterator.hasNext()) {
                Action action = (Action)((Tuple2)closeableIterator.next())._1;
                if (action instanceof Protocol && protocol == null) {
                    protocol = (Protocol)action;
                    if (metadata == null) continue;
                    this.validateSupportedTable(protocol, metadata);
                    Tuple2<Protocol, Metadata> tuple2 = new Tuple2<Protocol, Metadata>(protocol, metadata);
                    return tuple2;
                }
                if (!(action instanceof Metadata) || metadata != null) continue;
                metadata = (Metadata)action;
                if (protocol == null) continue;
                this.validateSupportedTable(protocol, metadata);
                Tuple2<Protocol, Metadata> tuple2 = new Tuple2<Protocol, Metadata>(protocol, metadata);
                return tuple2;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not close iterator", iOException);
        }
        if (protocol == null) {
            throw new IllegalStateException(String.format("No protocol found at version %s", this.logSegment.version));
        }
        throw new IllegalStateException(String.format("No metadata found at version %s", this.logSegment.version));
    }

    private void validateSupportedTable(Protocol protocol, Metadata metadata) {
        switch (protocol.getMinReaderVersion()) {
            case 1: {
                break;
            }
            case 2: {
                this.verifySupportedColumnMappingMode(metadata);
                break;
            }
            case 3: {
                List<String> list = protocol.getReaderFeatures();
                Iterator<String> iterator = list.iterator();
                block13: while (iterator.hasNext()) {
                    String string;
                    switch (string = iterator.next()) {
                        case "deletionVectors": {
                            continue block13;
                        }
                        case "columnMapping": {
                            this.verifySupportedColumnMappingMode(metadata);
                            continue block13;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported table feature: " + string);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported protocol version: " + protocol.getMinReaderVersion());
            }
        }
    }

    private void verifySupportedColumnMappingMode(Metadata metadata) {
        String string = metadata.getConfiguration().get("delta.columnMapping.mode");
        if (!"none".equalsIgnoreCase(string) && !"name".equalsIgnoreCase(string)) {
            throw new UnsupportedOperationException("Unsupported column mapping mode: " + string);
        }
    }

    private void assertLogFilesBelongToTable(Path path, Stream<FileStatus> stream) {
    }
}

