/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.internal.actions.Action;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.RemoveFile;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.FilteredCloseableIterator;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.Tuple2;
import java.net.URI;
import java.util.HashMap;
import java.util.Optional;

public class ReverseActionsToAddFilesIterator
extends FilteredCloseableIterator<AddFile, Tuple2<Action, Boolean>> {
    private final Path dataPath;
    private final HashMap<UniqueFileActionTuple, RemoveFile> tombstonesFromJson;
    private final HashMap<UniqueFileActionTuple, AddFile> addFilesFromJson;

    public ReverseActionsToAddFilesIterator(Path path, CloseableIterator<Tuple2<Action, Boolean>> closeableIterator) {
        super(closeableIterator);
        this.dataPath = path;
        this.tombstonesFromJson = new HashMap();
        this.addFilesFromJson = new HashMap();
    }

    @Override
    protected Optional<AddFile> accept(Tuple2<Action, Boolean> tuple2) {
        Action action = (Action)tuple2._1;
        boolean bl = (Boolean)tuple2._2;
        if (action instanceof AddFile) {
            AddFile addFile = ((AddFile)action).copyWithDataChange(false).withAbsolutePath(this.dataPath);
            UniqueFileActionTuple uniqueFileActionTuple = new UniqueFileActionTuple(addFile.toURI(), addFile.getDeletionVectorUniqueId());
            boolean bl2 = this.tombstonesFromJson.containsKey(uniqueFileActionTuple);
            boolean bl3 = this.addFilesFromJson.containsKey(uniqueFileActionTuple);
            if (!bl3) {
                if (!bl) {
                    this.addFilesFromJson.put(uniqueFileActionTuple, addFile);
                }
                if (!bl2) {
                    return Optional.of(addFile);
                }
            }
        } else if (action instanceof RemoveFile && !bl) {
            RemoveFile removeFile = ((RemoveFile)action).copyWithDataChange(false).withAbsolutePath(this.dataPath);
            UniqueFileActionTuple uniqueFileActionTuple = new UniqueFileActionTuple(removeFile.toURI(), removeFile.getDeletionVectorUniqueId());
            this.tombstonesFromJson.put(uniqueFileActionTuple, removeFile);
        }
        return Optional.empty();
    }

    private static class UniqueFileActionTuple
    extends Tuple2<URI, Optional<String>> {
        UniqueFileActionTuple(URI uRI, Optional<String> optional) {
            super(uRI, optional);
        }
    }
}

