/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.client.FileReadContext;
import io.delta.kernel.client.JsonHandler;
import io.delta.kernel.client.ParquetHandler;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.FileDataReadResult;
import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.fs.FileStatus;
import io.delta.kernel.internal.actions.Action;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.CloseableIterable;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.Tuple2;
import io.delta.kernel.utils.Utils;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReverseFilesToActionsIterable
implements CloseableIterable<Tuple2<Action, Boolean>> {
    private final TableClient tableClient;
    private final List<FileStatus> reverseSortedFiles;

    public ReverseFilesToActionsIterable(TableClient tableClient, Stream<FileStatus> stream) {
        this.tableClient = tableClient;
        this.reverseSortedFiles = stream.sorted(Comparator.comparing(fileStatus -> new Path(fileStatus.getPath()).getName()).reversed()).collect(Collectors.toList());
    }

    @Override
    public CloseableIterator<Tuple2<Action, Boolean>> iterator() {
        return new CloseableIterator<Tuple2<Action, Boolean>>(){
            private final Iterator<FileStatus> filesIter;
            private Optional<CloseableIterator<Tuple2<Action, Boolean>>> actionsIter;
            {
                this.filesIter = ReverseFilesToActionsIterable.this.reverseSortedFiles.iterator();
                this.actionsIter = Optional.empty();
            }

            @Override
            public boolean hasNext() {
                this.tryEnsureNextActionsIterIsReady();
                return this.actionsIter.isPresent();
            }

            @Override
            public Tuple2<Action, Boolean> next() {
                return (Tuple2)this.actionsIter.get().next();
            }

            @Override
            public void close() throws IOException {
                if (this.actionsIter.isPresent()) {
                    this.actionsIter.get().close();
                    this.actionsIter = Optional.empty();
                }
            }

            private void tryEnsureNextActionsIterIsReady() {
                if (this.actionsIter.isPresent()) {
                    if (this.actionsIter.get().hasNext()) {
                        return;
                    }
                    try {
                        this.actionsIter.get().close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.actionsIter = Optional.empty();
                }
                while (this.filesIter.hasNext()) {
                    this.actionsIter = Optional.of(this.getNextActionsIter());
                    if (this.actionsIter.get().hasNext()) {
                        return;
                    }
                    try {
                        this.actionsIter.get().close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.actionsIter = Optional.empty();
                }
            }

            private CloseableIterator<Tuple2<Action, Boolean>> getNextActionsIter() {
                FileStatus fileStatus = this.filesIter.next();
                Path path = new Path(fileStatus.getPath());
                JsonHandler jsonHandler = ReverseFilesToActionsIterable.this.tableClient.getJsonHandler();
                CloseableIterator<FileReadContext> closeableIterator = jsonHandler.contextualizeFileReads(Utils.singletonCloseableIterator(InternalUtils.getScanFileRow(fileStatus)), Literal.TRUE);
                try {
                    if (path.getName().endsWith(".json")) {
                        return new ColumnarBatchToActionIterator(ReverseFilesToActionsIterable.this.tableClient.getJsonHandler().readJsonFiles(closeableIterator, SingleAction.READ_SCHEMA), false);
                    }
                    if (path.getName().endsWith(".parquet")) {
                        ParquetHandler parquetHandler = ReverseFilesToActionsIterable.this.tableClient.getParquetHandler();
                        CloseableIterator<FileReadContext> closeableIterator2 = parquetHandler.contextualizeFileReads(Utils.singletonCloseableIterator(InternalUtils.getScanFileRow(fileStatus)), Literal.TRUE);
                        return new ColumnarBatchToActionIterator(ReverseFilesToActionsIterable.this.tableClient.getParquetHandler().readParquetFiles(closeableIterator2, SingleAction.READ_SCHEMA), true);
                    }
                    throw new IllegalStateException(String.format("Unexpected log file path: %s", path));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        };
    }

    private class ColumnarBatchToActionIterator
    implements CloseableIterator<Tuple2<Action, Boolean>> {
        private final CloseableIterator<FileDataReadResult> batchIterator;
        private final boolean isFromCheckpoint;
        private CloseableIterator<Row> currentBatchIterator;

        ColumnarBatchToActionIterator(CloseableIterator<FileDataReadResult> closeableIterator, boolean bl) {
            this.batchIterator = closeableIterator;
            this.isFromCheckpoint = bl;
        }

        @Override
        public boolean hasNext() {
            if ((this.currentBatchIterator == null || !this.currentBatchIterator.hasNext()) && this.batchIterator.hasNext()) {
                this.currentBatchIterator = ((FileDataReadResult)this.batchIterator.next()).getData().getRows();
            }
            return this.currentBatchIterator != null && this.currentBatchIterator.hasNext();
        }

        @Override
        public Tuple2<Action, Boolean> next() {
            return new Tuple2<Action, Boolean>(SingleAction.fromRow((Row)this.currentBatchIterator.next(), ReverseFilesToActionsIterable.this.tableClient).unwrap(), this.isFromCheckpoint);
        }

        @Override
        public void close() throws IOException {
            if (this.currentBatchIterator != null) {
                this.currentBatchIterator.close();
            }
            if (this.batchIterator != null) {
                this.batchIterator.close();
            }
        }
    }
}

