/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.snapshot;

import io.delta.kernel.Snapshot;
import io.delta.kernel.TableNotFoundException;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.fs.FileStatus;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.checkpoints.CheckpointInstance;
import io.delta.kernel.internal.checkpoints.CheckpointMetaData;
import io.delta.kernel.internal.checkpoints.Checkpointer;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.ListUtils;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Logging;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.Tuple2;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SnapshotManager
implements Logging {
    public Snapshot buildLatestSnapshot(TableClient tableClient, Path path, Path path2) throws TableNotFoundException {
        return this.getSnapshotAtInit(tableClient, path, path2);
    }

    private CloseableIterator<FileStatus> listFrom(Path path, TableClient tableClient, long l) throws FileNotFoundException {
        this.logDebug(String.format("startVersion: %s", l));
        return tableClient.getFileSystemClient().listFrom(FileNames.listingPrefix(path, l));
    }

    private boolean isDeltaCommitOrCheckpointFile(String string) {
        return FileNames.isCheckpointFile(string) || FileNames.isCommitFile(string);
    }

    private Optional<CloseableIterator<FileStatus>> listFromOrNone(Path path, TableClient tableClient, long l) {
        try {
            CloseableIterator<FileStatus> closeableIterator = this.listFrom(path, tableClient, l);
            if (closeableIterator.hasNext()) {
                return Optional.of(closeableIterator);
            }
            return Optional.empty();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Optional.empty();
        }
    }

    protected final Optional<List<FileStatus>> listDeltaAndCheckpointFiles(Path path, TableClient tableClient, long l, Optional<Long> optional) {
        this.logDebug(String.format("startVersion: %s, versionToLoad: %s", l, optional));
        return this.listFromOrNone(path, tableClient, l).map(closeableIterator -> {
            ArrayList<FileStatus> arrayList = new ArrayList<FileStatus>();
            while (closeableIterator.hasNext()) {
                FileStatus fileStatus = (FileStatus)closeableIterator.next();
                if (!this.isDeltaCommitOrCheckpointFile(Path.getName(fileStatus.getPath())) || FileNames.isCheckpointFile(Path.getName(fileStatus.getPath())) && fileStatus.getSize() == 0L) continue;
                boolean bl = optional.map(l -> FileNames.getFileVersion(new Path(fileStatus.getPath())) <= l).orElse(true);
                if (!bl) break;
                arrayList.add(fileStatus);
            }
            return arrayList;
        });
    }

    private SnapshotImpl getSnapshotAtInit(TableClient tableClient, Path path, Path path2) throws TableNotFoundException {
        Checkpointer checkpointer = new Checkpointer(path);
        Optional<CheckpointMetaData> optional = checkpointer.readLastCheckpointFile(tableClient);
        Optional<LogSegment> optional2 = this.getLogSegmentFrom(path, tableClient, optional);
        return optional2.map(logSegment -> this.createSnapshot((LogSegment)logSegment, path, path2, tableClient)).orElseThrow(TableNotFoundException::new);
    }

    private SnapshotImpl createSnapshot(LogSegment logSegment, Path path, Path path2, TableClient tableClient) {
        String string = logSegment.checkpointVersionOpt.map(l -> String.format(" starting from checkpoint version %s.", l)).orElse(".");
        this.logInfo(() -> String.format("Loading version %s%s", logSegment.version, string));
        return new SnapshotImpl(path, path2, logSegment.version, logSegment, tableClient, logSegment.lastCommitTimestamp);
    }

    private Optional<LogSegment> getLogSegmentFrom(Path path, TableClient tableClient, Optional<CheckpointMetaData> optional) {
        return this.getLogSegmentForVersion(path, tableClient, optional.map(checkpointMetaData -> checkpointMetaData.version), Optional.empty());
    }

    private Optional<LogSegment> getLogSegmentForVersion(Path path, TableClient tableClient, Optional<Long> optional, Optional<Long> optional2) {
        Optional<List<FileStatus>> optional3 = this.listDeltaAndCheckpointFiles(path, tableClient, optional.orElse(0L), optional2);
        return this.getLogSegmentForVersion(path, tableClient, optional, optional2, optional3);
    }

    private Optional<LogSegment> getLogSegmentForVersion(Path path, TableClient tableClient, Optional<Long> optional, Optional<Long> optional2, Optional<List<FileStatus>> optional3) {
        long l;
        List<FileStatus> list;
        if (optional3.isPresent()) {
            list = optional3.get();
        } else {
            if (!optional.isPresent()) {
                return Optional.empty();
            }
            list = Collections.emptyList();
        }
        this.logDebug(() -> String.format("newFiles: %s", Arrays.toString(list.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray())));
        if (list.isEmpty() && !optional.isPresent()) {
            throw new RuntimeException(String.format("Empty directory: %s", path));
        }
        if (list.isEmpty()) {
            return this.getLogSegmentForVersion(path, tableClient, Optional.empty(), optional2);
        }
        Tuple2<List<FileStatus>, List<FileStatus>> tuple2 = ListUtils.partition(list, fileStatus -> FileNames.isCheckpointFile(new Path(fileStatus.getPath()).getName()));
        List list2 = (List)tuple2._1;
        List list3 = (List)tuple2._2;
        this.logDebug(() -> String.format("\ncheckpoints: %s\ndeltas: %s", Arrays.toString(list2.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray()), Arrays.toString(list3.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray())));
        CheckpointInstance checkpointInstance2 = optional2.map(CheckpointInstance::new).orElse(CheckpointInstance.MAX_VALUE);
        this.logDebug(String.format("lastCheckpoint: %s", checkpointInstance2));
        List<CheckpointInstance> list4 = list2.stream().map(fileStatus -> new CheckpointInstance(new Path(fileStatus.getPath()))).collect(Collectors.toList());
        this.logDebug(() -> String.format("checkpointFiles: %s", Arrays.toString(list4.toArray())));
        Optional<CheckpointInstance> optional4 = Checkpointer.getLatestCompleteCheckpointFromList(list4, checkpointInstance2);
        this.logDebug(String.format("newCheckpointOpt: %s", optional4));
        long l3 = optional4.map(checkpointInstance -> checkpointInstance.version).orElseGet(() -> {
            optional.map(l -> {
                long l2 = optional2.orElseGet(() -> {
                    FileStatus fileStatus = (FileStatus)list3.get(list3.size() - 1);
                    return FileNames.deltaVersion(new Path(fileStatus.getPath()));
                });
                return this.getLogSegmentWithMaxExclusiveCheckpointVersion(l2, (long)l).orElseThrow(() -> new RuntimeException(String.format("Checkpoint file to load version: %s is missing.", l)));
            });
            return -1L;
        });
        this.logDebug(String.format("newCheckpointVersion: %s", l3));
        List<FileStatus> list5 = list3.stream().filter(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath())) > l3).collect(Collectors.toList());
        this.logDebug(() -> String.format("deltasAfterCheckpoint: %s", Arrays.toString(list5.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray())));
        LinkedList linkedList = list5.stream().map(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath()))).collect(Collectors.toCollection(LinkedList::new));
        this.logDebug(() -> String.format("deltaVersions: %s", Arrays.toString(linkedList.toArray())));
        if (!linkedList.isEmpty()) {
            if ((Long)linkedList.getFirst() != l3 + 1L) {
                throw new RuntimeException(String.format("Log file not found.\nExpected: %s\nFound:%s", FileNames.deltaFile(path, l3 + 1L), FileNames.deltaFile(path, (Long)linkedList.get(0))));
            }
            SnapshotManager.verifyDeltaVersions(linkedList, Optional.of(l3 + 1L), optional2);
        }
        long l4 = l = linkedList.isEmpty() ? optional4.get().version : (Long)linkedList.getLast();
        if (list3.isEmpty()) {
            throw new IllegalStateException(String.format("Could not find any delta files for version %s", l));
        }
        if (optional2.map(l2 -> l2 != l).orElse(false).booleanValue()) {
            throw new IllegalStateException(String.format("Trying to load a non-existent version %s", optional2.get()));
        }
        long l5 = ((FileStatus)list3.get(list3.size() - 1)).getModificationTime();
        List<FileStatus> list6 = optional4.map(checkpointInstance -> {
            HashSet<Path> hashSet = new HashSet<Path>(checkpointInstance.getCorrespondingFiles(path));
            List list2 = list2.stream().filter(fileStatus -> hashSet.contains(new Path(fileStatus.getPath()))).collect(Collectors.toList());
            if (list2.size() != hashSet.size()) {
                String string = String.format("Seems like the checkpoint is corrupted. Failed in getting the file information for:\n%s\namong\n%s", hashSet.stream().map(Path::toString).collect(Collectors.toList()), list2.stream().map(FileStatus::getPath).collect(Collectors.joining("\n - ")));
                throw new IllegalStateException(string);
            }
            return list2;
        }).orElse(Collections.emptyList());
        return Optional.of(new LogSegment(path, l, list5, list6, optional4.map(checkpointInstance -> checkpointInstance.version), l5));
    }

    private Optional<LogSegment> getLogSegmentWithMaxExclusiveCheckpointVersion(long l, long l2) {
        return Optional.empty();
    }

    public static void verifyDeltaVersions(List<Long> list, Optional<Long> optional, Optional<Long> optional2) {
        if (!list.isEmpty()) {
            // empty if block
        }
        optional.ifPresent(l -> {
            assert (!list.isEmpty() && Objects.equals(list.get(0), l)) : String.format("Did not get the first delta file version %s to compute Snapshot", l);
        });
        optional2.ifPresent(l -> {
            assert (!list.isEmpty() && Objects.equals(list.get(list.size() - 1), l)) : String.format("Did not get the last delta file version %s to compute Snapshot", l);
        });
    }
}

